/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.renderer;

import java.io.IOException;
import java.util.ArrayList;
import org.cyclerecorder.footprintbuilder.Utility;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.PadPin;
import org.cyclerecorder.footprintbuilder.data.SilkLine;
import org.cyclerecorder.footprintbuilder.data.UnitType;
import org.cyclerecorder.footprintbuilder.renderer.AppendableRenderer;

public final class PcbRenderer
extends AppendableRenderer {
    @Override
    public void render(Appendable buffer, Footprint footprint) throws IOException {
        ArrayList<PadPin> padPins = footprint.getPadPins();
        ArrayList<SilkLine> silkLines = footprint.getSilkLines();
        PcbRenderer.renderStart(buffer, footprint);
        for (PadPin padPin : padPins) {
            PcbRenderer.renderPadPin(buffer, footprint, padPin);
        }
        for (SilkLine silkLine : silkLines) {
            PcbRenderer.renderSilkLine(buffer, footprint, silkLine);
        }
        PcbRenderer.renderEnd(buffer, footprint);
    }

    private static void renderStart(Appendable buffer, Footprint footprint) throws IOException {
        buffer.append("Element[\"\"");
        buffer.append(" \"").append(PcbRenderer.toString(footprint.getDescription())).append("\"");
        buffer.append(" \"").append(PcbRenderer.toString(footprint.getName())).append("\"");
        buffer.append(" \"\" 0 0 0 0 0 100 \"\"]\n(\n");
    }

    private static void renderEnd(Appendable buffer, Footprint footprint) throws IOException {
        buffer.append(")\n");
    }

    private static void renderPadPin(Appendable buffer, Footprint footprint, PadPin padPin) throws IOException {
        double x = padPin.getX();
        double y = padPin.getY();
        String number = padPin.getNumber();
        if (padPin.isPad()) {
            double y2;
            double y1;
            double x1;
            double x2;
            double thickness;
            double xo = padPin.getXOffset();
            double yo = padPin.getYOffset();
            double width = padPin.getPadWidth();
            double length = padPin.getPadLength();
            double angle = padPin.getAngle();
            boolean square = padPin.isRectangle();
            double halfWidth = width / 2.0;
            double halfLength = length / 2.0;
            if (width < length) {
                thickness = width;
                x2 = 0.0;
                x1 = 0.0;
                y1 = -halfLength + halfWidth;
                y2 = halfLength - halfWidth;
            } else {
                thickness = length;
                x1 = -halfWidth + halfLength;
                x2 = halfWidth - halfLength;
                y2 = 0.0;
                y1 = 0.0;
            }
            x1 += xo;
            y1 += yo;
            x2 += xo;
            y2 += yo;
            double clearance = padPin.getClearanceOffset() * 2.0;
            double mask = thickness + padPin.getMaskOffset() * 2.0;
            double cos = Utility.getCosOfDegrees(angle);
            double sin = Utility.getSinOfDegrees(angle);
            double tx1 = cos * x1 + -sin * y1 + x;
            double ty1 = sin * x1 + cos * y1 + y;
            double tx2 = cos * x2 + -sin * y2 + x;
            double ty2 = sin * x2 + cos * y2 + y;
            PcbRenderer.renderPad(buffer, footprint.getUnitType(), tx1, ty1, tx2, ty2, thickness, clearance, mask, number, square);
        }
        if (padPin.isPin() || padPin.isHoleOnly()) {
            double thickness = padPin.getPinDiameter();
            double drill = padPin.getHoleDiameter();
            boolean holeOnly = padPin.isHoleOnly();
            double clearance = padPin.getClearanceOffset() * 2.0;
            double mask = Math.max(thickness, drill) + padPin.getMaskOffset() * 2.0;
            PcbRenderer.renderPin(buffer, footprint.getUnitType(), x, y, thickness, clearance, mask, drill, number, holeOnly);
        }
    }

    private static void renderSilkLine(Appendable buffer, Footprint footprint, SilkLine silkLine) throws IOException {
        double x1 = silkLine.getX1();
        double y1 = silkLine.getY1();
        double x2 = silkLine.getX2();
        double y2 = silkLine.getY2();
        double thickness = silkLine.getThickness();
        PcbRenderer.renderLine(buffer, footprint.getUnitType(), x1, y1, x2, y2, thickness);
    }

    private static void renderPad(Appendable buffer, UnitType unitType, double x1, double y1, double x2, double y2, double thickness, double clearance, double mask, String number, boolean square) throws IOException {
        buffer.append("\tPad[").append(PcbRenderer.toCentMil(unitType, x1));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, y1));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, x2));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, y2));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, thickness));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, clearance));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, mask));
        buffer.append(" \"").append(PcbRenderer.toString(number)).append("\"");
        buffer.append(" \"").append(PcbRenderer.toString(number)).append("\"");
        buffer.append(" \"").append(square ? "square" : "").append("\"");
        buffer.append("]\n");
    }

    private static void renderPin(Appendable buffer, UnitType unitType, double x, double y, double thickness, double clearance, double mask, double drill, String number, boolean holeOnly) throws IOException {
        buffer.append("\tPin[").append(PcbRenderer.toCentMil(unitType, x));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, y));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, thickness));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, clearance));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, mask));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, drill));
        buffer.append(" \"").append(PcbRenderer.toString(number)).append("\"");
        buffer.append(" \"").append(PcbRenderer.toString(number)).append("\"");
        buffer.append(" \"").append(holeOnly ? "hole" : "").append("\"");
        buffer.append("]\n");
    }

    public static void renderLine(Appendable buffer, UnitType unitType, double x1, double y1, double x2, double y2, double thickness) throws IOException {
        buffer.append("\tElementLine[").append(PcbRenderer.toCentMil(unitType, x1));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, y1));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, x2));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, y2));
        buffer.append(" ").append(PcbRenderer.toCentMil(unitType, thickness));
        buffer.append("]\n");
    }

    private static String toCentMil(UnitType unit, double value) {
        return Integer.toString((int)unit.toCentiMil(value));
    }

    private static String toString(String string) {
        return string != null ? string : "";
    }
}

