/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.renderer;

import java.io.IOException;
import java.util.ArrayList;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.PadPin;
import org.cyclerecorder.footprintbuilder.data.SilkLine;
import org.cyclerecorder.footprintbuilder.data.UnitType;
import org.cyclerecorder.footprintbuilder.renderer.AppendableRenderer;

public final class KicadRenderer
extends AppendableRenderer {
    @Override
    public void render(Appendable buffer, Footprint footprint) throws IOException {
        ArrayList<PadPin> padPins = footprint.getPadPins();
        ArrayList<SilkLine> silkLines = footprint.getSilkLines();
        UnitType unitType = footprint.getUnitType();
        KicadRenderer.renderStart(buffer, footprint);
        for (SilkLine silkLine : silkLines) {
            double x1 = silkLine.getX1();
            double y1 = silkLine.getY1();
            double x2 = silkLine.getX2();
            double y2 = silkLine.getY2();
            double thickness = silkLine.getThickness();
            buffer.append("DS ").append(KicadRenderer.toDeciMil(unitType, x1));
            buffer.append(" ").append(KicadRenderer.toDeciMil(unitType, y1));
            buffer.append(" ").append(KicadRenderer.toDeciMil(unitType, x2));
            buffer.append(" ").append(KicadRenderer.toDeciMil(unitType, y2));
            buffer.append(" ").append(KicadRenderer.toDeciMil(unitType, thickness));
            buffer.append(" 21\n");
        }
        for (PadPin padPin : padPins) {
            String shape;
            String number = padPin.getNumber();
            double x = padPin.getX();
            double px = padPin.getXOffset();
            double y = padPin.getY();
            double py = padPin.getYOffset();
            double width = padPin.getPadWidth();
            double length = padPin.getPadLength();
            boolean rectangle = padPin.isRectangle();
            double pin = padPin.getPinDiameter();
            double hole = padPin.getHoleDiameter();
            boolean holeOnly = padPin.isHoleOnly();
            double angle = padPin.getAngle();
            if (angle == 90.0) {
                angle = 270.0;
            } else if (angle == 270.0) {
                angle = 90.0;
            }
            angle *= 10.0;
            double w = width;
            double l = length;
            String string = shape = rectangle ? "R" : "O";
            if (padPin.isHoleOnly()) {
                w = l = hole;
                shape = "C";
            } else if (padPin.isPin()) {
                w = l = pin;
                shape = "C";
            }
            buffer.append("$PAD\n");
            buffer.append("Sh \"").append(KicadRenderer.toString(number)).append("\"");
            buffer.append(" ").append(shape);
            buffer.append(" ").append(KicadRenderer.toDeciMil(unitType, w));
            buffer.append(" ").append(KicadRenderer.toDeciMil(unitType, l));
            buffer.append(" ").append(KicadRenderer.toDeciMil(unitType, 0.0));
            buffer.append(" ").append(KicadRenderer.toDeciMil(unitType, 0.0));
            buffer.append(" ").append(Integer.toString((int)angle)).append("\n");
            buffer.append("Dr ").append(KicadRenderer.toDeciMil(unitType, hole));
            buffer.append(" ").append(KicadRenderer.toDeciMil(unitType, px));
            buffer.append(" ").append(KicadRenderer.toDeciMil(unitType, py)).append("\n");
            if (padPin.isPad()) {
                buffer.append("At SMD N 00888000\n");
            } else if (padPin.isHoleOnly()) {
                buffer.append("At HOLE N 00F0FFFF\n");
            } else if (padPin.isPin()) {
                buffer.append("At STD N 00E0FFFF\n");
            }
            buffer.append("Po ").append(KicadRenderer.toDeciMil(unitType, x));
            buffer.append(" ").append(KicadRenderer.toDeciMil(unitType, y)).append("\n");
            buffer.append("$EndPAD\n");
        }
        KicadRenderer.renderEnd(buffer, footprint);
    }

    private static void renderStart(Appendable buffer, Footprint footprint) throws IOException {
        buffer.append("PCBNEW-LibModule-V1\n");
        buffer.append("$INDEX\n");
        buffer.append(KicadRenderer.toString(footprint.getName())).append("\n");
        buffer.append("$EndINDEX\n");
        buffer.append("$MODULE ").append(KicadRenderer.toString(footprint.getName())).append("\n");
        buffer.append("Po 0 0 0 15 0 0 ~~\n");
        buffer.append("Li ").append(KicadRenderer.toString(footprint.getName())).append("\n");
        if (KicadRenderer.toString(footprint.getDescription()).length() > 0) {
            buffer.append("Cd ").append(KicadRenderer.toString(footprint.getDescription())).append("\n");
        }
        buffer.append("Sc 0\n");
        buffer.append("Op 0 0 0\n");
        buffer.append("T0 0 0 600 600 0 120 N V 21 \"").append(KicadRenderer.toString(footprint.getName())).append("\"\n");
        buffer.append("T1 0 0 600 600 0 120 N V 21 \"VAL**\"\n");
    }

    private static void renderEnd(Appendable buffer, Footprint footprint) throws IOException {
        buffer.append("$EndMODULE ").append(KicadRenderer.toString(footprint.getName())).append("\n");
        buffer.append("$EndLIBRARY\n");
    }

    private static String toDeciMil(UnitType unit, double value) {
        return Integer.toString((int)unit.toDeciMil(value));
    }

    private static String toString(String string) {
        return string != null ? string : "";
    }
}

