/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import org.cyclerecorder.footprintbuilder.data.BoundingRectangle;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.Group;
import org.cyclerecorder.footprintbuilder.data.PadPin;
import org.cyclerecorder.footprintbuilder.data.SilkLine;
import org.cyclerecorder.footprintbuilder.renderer.Renderer;

public final class Graphics2DRenderer
extends Renderer<Graphics2D> {
    private static final Color boardColor = new Color(204, 204, 119);
    private static final Color copperColor = new Color(102, 102, 102);
    private static final Color maskColor = new Color(0, 153, 0);
    private static final Color clearColor = new Color(204, 204, 204);
    private static final Color silkColor = Color.WHITE;
    private static final Color outlineColor = Color.BLACK;
    private static final Color numberColor = new Color(255, 0, 0);
    private static final Color overlayColor = Color.BLACK;

    @Override
    public void render(Graphics2D g2, Footprint footprint) throws IOException {
        EnumMap<Group, BoundingRectangle> groupBounds = footprint.buildGroupBounds(0.0);
        BoundingRectangle allBR = groupBounds.get((Object)Group.ALL);
        Rectangle bounds = g2.getClipBounds() != null ? g2.getClipBounds() : g2.getDeviceConfiguration().getBounds();
        int boundsWidth = bounds.x + bounds.width;
        int boundsHeight = bounds.y + bounds.height;
        g2.setColor(maskColor);
        g2.fillRect(0, 0, boundsWidth, boundsHeight);
        g2.translate(boundsWidth / 2, boundsHeight / 2);
        AffineTransform tx = g2.getTransform();
        double scaleW = (double)boundsWidth / (allBR.getWidth() * 1.5);
        double scaleL = (double)boundsHeight / (allBR.getLength() * 1.5);
        double scale = Math.min(scaleW, scaleL);
        g2.scale(scale, scale);
        this.renderFootprint(g2, footprint);
        g2.setTransform(tx);
        g2.setColor(overlayColor);
        g2.setFont(new Font("Monospaced", 0, 12));
        g2.drawLine(-(boundsWidth / 2), 0, boundsWidth / 2, 0);
        g2.drawLine(0, -(boundsHeight / 2), 0, boundsHeight / 2);
        Graphics2DRenderer.drawText(g2, "Top View", 0, -boundsHeight / 2 + g2.getFontMetrics().getHeight() * 1);
    }

    private void renderFootprint(Graphics2D g2, Footprint footprint) throws IOException {
        ArrayList<PadPin> padPins = footprint.getPadPins();
        ArrayList<SilkLine> silkLines = footprint.getSilkLines();
        ArrayList<Shape> negMaskList = new ArrayList<Shape>();
        ArrayList<Shape> copperList = new ArrayList<Shape>();
        ArrayList<Shape> negHoleList = new ArrayList<Shape>();
        ArrayList outlineList = new ArrayList();
        for (PadPin padPin : padPins) {
            double x = padPin.getX();
            double y = padPin.getY();
            if (padPin.isPad()) {
                double xo = padPin.getXOffset();
                double yo = padPin.getYOffset();
                double width = padPin.getPadWidth();
                double length = padPin.getPadLength();
                double angle = padPin.getAngle();
                boolean square = padPin.isRectangle();
                double mask = padPin.getMaskOffset() * 2.0;
                copperList.add(Graphics2DRenderer.createShape(x, y, xo, yo, angle, width, length, square));
                negMaskList.add(Graphics2DRenderer.createShape(x, y, xo, yo, angle, width + mask, length + mask, square));
            }
            if (!padPin.isPin() && !padPin.isHoleOnly()) continue;
            double pinDiameter = padPin.getPinDiameter();
            double holeDiameter = padPin.getHoleDiameter();
            double mask = padPin.getMaskOffset() * 2.0;
            if (!padPin.isHoleOnly()) {
                copperList.add(Graphics2DRenderer.createShape(x, y, pinDiameter, false));
                negMaskList.add(Graphics2DRenderer.createShape(x, y, pinDiameter + mask, false));
            }
            negHoleList.add(Graphics2DRenderer.createShape(x, y, holeDiameter, false));
        }
        g2.setColor(boardColor);
        for (Shape maskShape : negMaskList) {
            g2.fill(maskShape);
        }
        g2.setColor(copperColor);
        for (Shape copperShape : copperList) {
            g2.fill(copperShape);
        }
        g2.setColor(clearColor);
        for (Shape holeShape : negHoleList) {
            g2.fill(holeShape);
        }
        g2.setColor(silkColor);
        Stroke orignalStroke = g2.getStroke();
        for (SilkLine silkLine : silkLines) {
            Line2D.Double line = new Line2D.Double(silkLine.getX1(), silkLine.getY1(), silkLine.getX2(), silkLine.getY2());
            g2.setStroke(new BasicStroke((float)silkLine.getThickness(), 1, 1));
            g2.draw(line);
        }
        g2.setStroke(orignalStroke);
        g2.setColor(outlineColor);
        for (Shape outlineShape : outlineList) {
            g2.draw(outlineShape);
        }
    }

    private static Shape createShape(double x, double y, double xo, double yo, double angle, double width, double length, boolean square) {
        Shape shape;
        double halfWidth = width / 2.0;
        double halfLength = length / 2.0;
        if (square) {
            shape = new Rectangle2D.Double(-halfWidth, -halfLength, width, length);
        } else {
            double arc = Math.min(width, length);
            shape = new RoundRectangle2D.Double(-halfWidth, -halfLength, width, length, arc, arc);
        }
        shape = AffineTransform.getTranslateInstance(xo, yo).createTransformedShape(shape);
        shape = AffineTransform.getRotateInstance(Math.toRadians(angle)).createTransformedShape(shape);
        shape = AffineTransform.getTranslateInstance(x, y).createTransformedShape(shape);
        return shape;
    }

    private static Shape createShape(double x, double y, double side, boolean square) {
        double halfSide = side / 2.0;
        if (square) {
            return new Rectangle2D.Double(x + -halfSide, y + -halfSide, side, side);
        }
        return new Ellipse2D.Double(x + -halfSide, y + -halfSide, side, side);
    }

    private static void drawText(Graphics2D g2, String string, int x, int y) {
        FontMetrics fontMetrics = g2.getFontMetrics();
        int width = fontMetrics.stringWidth(string);
        g2.drawString(string, x - width / 2, y);
    }
}

