/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.gui;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.data.UnitType;
import org.cyclerecorder.footprintbuilder.editable.EditableDouble;
import org.cyclerecorder.footprintbuilder.editable.EditableInteger;
import org.cyclerecorder.footprintbuilder.editable.EditableNumber;

public final class EditableJSpinner
extends JSpinner {
    private final boolean isPositive;
    private UnitType unitType;

    private EditableJSpinner(boolean isPositive, EditableSpinnerNumberModel model, ChangeListener changeListener) {
        super(model);
        this.isPositive = isPositive;
        this.addChangeListener(changeListener);
    }

    public EditableJSpinner(boolean isPositive, EditableInteger editable, ChangeListener changeListener) {
        this(isPositive, isPositive ? new EditableSpinnerNumberModel(editable, 0, 100, 1) : new EditableSpinnerNumberModel(editable, -100, 100, 1), changeListener);
    }

    public EditableJSpinner(boolean isPositive, EditableDouble editable, ChangeListener changeListener) {
        this(isPositive, new EditableSpinnerNumberModel(editable, 0.0, 1000.0, 0.0), changeListener);
    }

    public void setUnitType(UnitType unitType) {
        UnitType oldUnitType = this.unitType;
        if (unitType == oldUnitType) {
            return;
        }
        this.unitType = unitType;
        EditableSpinnerNumberModel model = (EditableSpinnerNumberModel)this.getModel();
        if (!(model.editable instanceof EditableDouble)) {
            throw new UnsupportedOperationException("The setUnitType method is only supported for EditableDouble objects.");
        }
        double minimum = 0.0;
        double maximum = 0.0;
        double stepSize = 0.0;
        switch (this.unitType) {
            case MM: {
                maximum = 200.0;
                minimum = -maximum;
                stepSize = 0.01;
                break;
            }
            case MIL: {
                maximum = 8000.0;
                minimum = -maximum;
                stepSize = 0.5;
                break;
            }
            case INCH: {
                maximum = 8.0;
                minimum = -maximum;
                stepSize = 0.001;
            }
        }
        if (this.isPositive) {
            minimum = 0.0;
        }
        model.setMinimum(Double.valueOf(minimum));
        model.setMaximum(Double.valueOf(maximum));
        model.setStepSize(stepSize);
        double value = UnitType.convert(oldUnitType, model.editable.doubleValue(), this.unitType);
        value = (double)((long)(value / stepSize)) * stepSize;
        model.setValue(value);
    }

    private static final class EditableSpinnerNumberModel
    extends SpinnerNumberModel {
        private final EditableNumber editable;

        public EditableSpinnerNumberModel(EditableInteger editable, int minimum, int maximum, int stepSize) {
            super(editable.intValue(), minimum, maximum, stepSize);
            this.editable = editable;
        }

        public EditableSpinnerNumberModel(EditableDouble editable, double minimum, double maximum, double stepSize) {
            super(editable.doubleValue(), minimum, maximum, stepSize);
            this.editable = editable;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Number) {
                this.editable.setValue((Number)value);
            }
            super.setValue(value);
        }
    }
}

