/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.editable.EditableEnum;

public final class EditableJComboBox
extends JComboBox {
    private EditableJComboBox(EditableComboBoxModel model, final ChangeListener changeListener) {
        super(model);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                changeListener.stateChanged(new ChangeEvent(ie.getSource()));
            }
        });
    }

    public EditableJComboBox(EditableEnum editable, ChangeListener changeListener) {
        this(new EditableComboBoxModel(editable), changeListener);
    }

    private static final class EditableComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final EditableEnum editable;

        public EditableComboBoxModel(EditableEnum editable) {
            this.editable = editable;
        }

        @Override
        public int getSize() {
            return this.editable.getValues().length;
        }

        @Override
        public Object getElementAt(int row) {
            return this.editable.getValues()[row];
        }

        @Override
        public Object getSelectedItem() {
            return this.editable.getValue();
        }

        @Override
        public void setSelectedItem(Object o) {
            this.editable.setEnumValue((Enum)o);
        }
    }
}

