/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.editor;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.PackageType;
import org.cyclerecorder.footprintbuilder.data.UnitType;
import org.cyclerecorder.footprintbuilder.editable.PadEditable;
import org.cyclerecorder.footprintbuilder.editable.QuadEditable;
import org.cyclerecorder.footprintbuilder.editor.EditorPanel;
import org.cyclerecorder.footprintbuilder.gui.EditableJComboBox;
import org.cyclerecorder.footprintbuilder.gui.EditableJSpinner;

public class QuadEditor
extends EditorPanel {
    private final QuadEditable quad = new QuadEditable();
    private final EditableJSpinner xPadWidth;
    private final EditableJSpinner xPadLength;
    private final EditableJSpinner quadXCount;
    private final EditableJSpinner quadXPitch;
    private final EditableJSpinner quadVerticalPitch;
    private final EditableJSpinner yPadWidth;
    private final EditableJSpinner yPadLength;
    private final EditableJSpinner quadYCount;
    private final EditableJSpinner quadYPitch;
    private final EditableJSpinner quadHorizontalPitch;
    private final EditableJComboBox quadOffsetType;
    private final EditableJSpinner ePadWidth;
    private final EditableJSpinner ePadLength;

    public QuadEditor(PackageType packageType, ChangeListener changeListener) {
        super(packageType, changeListener);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        PadEditable xpad = this.quad.getXPad();
        PadEditable ypad = this.quad.getYPad();
        PadEditable epad = this.quad.getEPad();
        JLabel horizontalLabel = new JLabel("Top/Bottom Pads");
        JLabel xPadWidthLabel = new JLabel("Pad Width");
        this.xPadWidth = new EditableJSpinner(true, xpad.getPadWidthEditable(), changeListener);
        xPadWidthLabel.setLabelFor(this.xPadWidth);
        JLabel xPadLengthLabel = new JLabel("Pad Length");
        this.xPadLength = new EditableJSpinner(true, xpad.getPadLengthEditable(), changeListener);
        xPadLengthLabel.setLabelFor(this.xPadLength);
        JLabel quadXCountLabel = new JLabel("Count");
        this.quadXCount = new EditableJSpinner(true, this.quad.getXCountEditable(), changeListener);
        quadXCountLabel.setLabelFor(this.quadXCount);
        JLabel quadXPitchLabel = new JLabel("Pitch");
        this.quadXPitch = new EditableJSpinner(true, this.quad.getXPitchEditable(), changeListener);
        quadXPitchLabel.setLabelFor(this.quadXPitch);
        JLabel quadVerticalPitchLabel = new JLabel("Vertical Pitch");
        this.quadVerticalPitch = new EditableJSpinner(true, this.quad.getVerticalPitchEditable(), changeListener);
        quadVerticalPitchLabel.setLabelFor(this.quadVerticalPitch);
        JLabel verticalLabel = new JLabel("Left/Right Pads");
        JLabel yPadWidthLabel = new JLabel("Pad Width");
        this.yPadWidth = new EditableJSpinner(true, ypad.getPadWidthEditable(), changeListener);
        yPadWidthLabel.setLabelFor(this.yPadWidth);
        JLabel yPadLengthLabel = new JLabel("Pad Length");
        this.yPadLength = new EditableJSpinner(true, ypad.getPadLengthEditable(), changeListener);
        yPadLengthLabel.setLabelFor(this.yPadLength);
        JLabel quadYCountLabel = new JLabel("Count");
        this.quadYCount = new EditableJSpinner(true, this.quad.getYCountEditable(), changeListener);
        quadYCountLabel.setLabelFor(this.quadYCount);
        JLabel quadYPitchLabel = new JLabel("Pitch");
        this.quadYPitch = new EditableJSpinner(true, this.quad.getYPitchEditable(), changeListener);
        quadYPitchLabel.setLabelFor(this.quadYPitch);
        JLabel quadHorizontalPitchLabel = new JLabel("Horizontal Pitch");
        this.quadHorizontalPitch = new EditableJSpinner(true, this.quad.getHorizontalPitchEditable(), changeListener);
        quadHorizontalPitchLabel.setLabelFor(this.quadHorizontalPitch);
        JLabel quadOffsetTypeLabel = new JLabel("H/V Pitch Offset");
        this.quadOffsetType = new EditableJComboBox(this.quad.getOffsetTypeEditable(), changeListener);
        quadOffsetTypeLabel.setLabelFor(this.quadOffsetType);
        JLabel ePadLabel = new JLabel("Exposed Pad");
        JLabel ePadWidthLabel = new JLabel("Width");
        this.ePadWidth = new EditableJSpinner(true, epad.getPadWidthEditable(), changeListener);
        ePadWidthLabel.setLabelFor(this.ePadWidth);
        JLabel ePadLengthLabel = new JLabel("Length");
        this.ePadLength = new EditableJSpinner(true, epad.getPadLengthEditable(), changeListener);
        ePadLengthLabel.setLabelFor(this.ePadLength);
        layout.linkSize(0, xPadWidthLabel, xPadLengthLabel, quadXCountLabel, quadXPitchLabel, quadVerticalPitchLabel);
        layout.linkSize(0, yPadWidthLabel, yPadLengthLabel, quadYCountLabel, quadYPitchLabel, quadHorizontalPitchLabel, quadOffsetTypeLabel);
        layout.linkSize(0, ePadWidthLabel, ePadLengthLabel);
        layout.linkSize(0, xPadWidthLabel, yPadWidthLabel, ePadWidthLabel);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createParallelGroup().addComponent(horizontalLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(xPadWidthLabel).addComponent(xPadLengthLabel).addComponent(quadXCountLabel).addComponent(quadXPitchLabel).addComponent(quadVerticalPitchLabel)).addGroup(layout.createParallelGroup().addComponent(this.xPadWidth).addComponent(this.xPadLength).addComponent(this.quadXCount).addComponent(this.quadXPitch).addComponent(this.quadVerticalPitch)))).addGroup(layout.createParallelGroup().addComponent(verticalLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(yPadWidthLabel).addComponent(yPadLengthLabel).addComponent(quadYCountLabel).addComponent(quadYPitchLabel).addComponent(quadHorizontalPitchLabel)).addGroup(layout.createParallelGroup().addComponent(this.yPadWidth).addComponent(this.yPadLength).addComponent(this.quadYCount).addComponent(this.quadYPitch).addComponent(this.quadHorizontalPitch)))).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(quadOffsetTypeLabel)).addGroup(layout.createParallelGroup().addComponent(this.quadOffsetType)))).addGroup(layout.createParallelGroup().addComponent(ePadLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(ePadWidthLabel).addComponent(ePadLengthLabel)).addGroup(layout.createParallelGroup().addComponent(this.ePadWidth).addComponent(this.ePadLength)))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createSequentialGroup().addComponent(horizontalLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(xPadWidthLabel).addComponent(this.xPadWidth)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(xPadLengthLabel).addComponent(this.xPadLength)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(quadXCountLabel).addComponent(this.quadXCount)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(quadXPitchLabel).addComponent(this.quadXPitch)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(quadVerticalPitchLabel).addComponent(this.quadVerticalPitch))).addGroup(layout.createSequentialGroup().addComponent(verticalLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(yPadWidthLabel).addComponent(this.yPadWidth)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(yPadLengthLabel).addComponent(this.yPadLength)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(quadYCountLabel).addComponent(this.quadYCount)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(quadYPitchLabel).addComponent(this.quadYPitch)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(quadHorizontalPitchLabel).addComponent(this.quadHorizontalPitch))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(quadOffsetTypeLabel).addComponent(this.quadOffsetType))).addGroup(layout.createSequentialGroup().addComponent(ePadLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(ePadWidthLabel).addComponent(this.ePadWidth)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(ePadLengthLabel).addComponent(this.ePadLength))));
    }

    @Override
    public void fillFootprint(Footprint footprint) {
        this.quad.fillFootprint(footprint);
    }

    @Override
    public void setUnitType(UnitType unitType) {
        this.xPadWidth.setUnitType(unitType);
        this.xPadLength.setUnitType(unitType);
        this.quadXPitch.setUnitType(unitType);
        this.quadVerticalPitch.setUnitType(unitType);
        this.yPadWidth.setUnitType(unitType);
        this.yPadLength.setUnitType(unitType);
        this.quadYPitch.setUnitType(unitType);
        this.quadHorizontalPitch.setUnitType(unitType);
        this.ePadWidth.setUnitType(unitType);
        this.ePadLength.setUnitType(unitType);
    }
}

