/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.editor;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.UnitType;
import org.cyclerecorder.footprintbuilder.editable.OptionsEditable;
import org.cyclerecorder.footprintbuilder.editor.EditorPanel;
import org.cyclerecorder.footprintbuilder.gui.EditableJSpinner;

public class OptionsEditor
extends EditorPanel {
    private final EditableJSpinner maskOffset;
    private final EditableJSpinner clearanceOffset;
    private final EditableJSpinner silkLineWidth;
    private final EditableJSpinner extraLength;

    public OptionsEditor(OptionsEditable options, ChangeListener changeListener) {
        super(null, changeListener);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        JLabel optionsLabel = new JLabel("Options");
        JLabel maskOffsetLabel = new JLabel("Mask Offset");
        this.maskOffset = new EditableJSpinner(true, options.getMaskOffsetEditable(), changeListener);
        maskOffsetLabel.setLabelFor(this.maskOffset);
        JLabel clearanceOffsetLabel = new JLabel("Clearance Offset");
        this.clearanceOffset = new EditableJSpinner(true, options.getClearanceOffsetEditable(), changeListener);
        clearanceOffsetLabel.setLabelFor(this.clearanceOffset);
        JLabel silkLineWidthLabel = new JLabel("Silk Line Width");
        this.silkLineWidth = new EditableJSpinner(true, options.getSilkLineWidthEditable(), changeListener);
        silkLineWidthLabel.setLabelFor(this.silkLineWidth);
        JLabel extraLengthLabel = new JLabel("Extra Length");
        this.extraLength = new EditableJSpinner(true, options.getExtraLengthEditable(), changeListener);
        extraLengthLabel.setLabelFor(this.extraLength);
        this.extraLength.setEnabled(false);
        layout.linkSize(0, maskOffsetLabel, clearanceOffsetLabel, silkLineWidthLabel, extraLengthLabel);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createParallelGroup().addComponent(optionsLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(maskOffsetLabel).addComponent(clearanceOffsetLabel).addComponent(silkLineWidthLabel).addComponent(extraLengthLabel)).addGroup(layout.createParallelGroup().addComponent(this.maskOffset).addComponent(this.clearanceOffset).addComponent(this.silkLineWidth).addComponent(this.extraLength)))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createSequentialGroup().addComponent(optionsLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(maskOffsetLabel).addComponent(this.maskOffset)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(clearanceOffsetLabel).addComponent(this.clearanceOffset)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(silkLineWidthLabel).addComponent(this.silkLineWidth)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(extraLengthLabel).addComponent(this.extraLength))));
    }

    @Override
    public void fillFootprint(Footprint footprint) {
    }

    @Override
    public void setUnitType(UnitType unitType) {
        this.maskOffset.setUnitType(unitType);
        this.clearanceOffset.setUnitType(unitType);
        this.silkLineWidth.setUnitType(unitType);
        this.extraLength.setUnitType(unitType);
    }
}

