/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.editor;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.PackageType;
import org.cyclerecorder.footprintbuilder.data.StyleType;
import org.cyclerecorder.footprintbuilder.data.UnitType;
import org.cyclerecorder.footprintbuilder.editable.GridEditable;
import org.cyclerecorder.footprintbuilder.editor.EditorPanel;
import org.cyclerecorder.footprintbuilder.gui.EditableJComboBox;
import org.cyclerecorder.footprintbuilder.gui.EditableJSpinner;

public class GridEditor
extends EditorPanel {
    private final GridEditable grid = new GridEditable();
    private final EditableJSpinner padWidth;
    private final EditableJSpinner pinDiameter;
    private final EditableJSpinner holeDiameter;
    private final EditableJSpinner xCount;
    private final EditableJSpinner xPitch;
    private final EditableJSpinner yCount;
    private final EditableJSpinner yPitch;
    private final EditableJComboBox pinNumberType;

    public GridEditor(PackageType packageType, ChangeListener changeListener) {
        super(packageType, changeListener);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        if (packageType == PackageType.GRID) {
            this.grid.getPad().setPadStyle(StyleType.CIRCLE);
        }
        JLabel padLabel = new JLabel("Pad");
        JLabel padWidthLabel = new JLabel("Width");
        this.padWidth = new EditableJSpinner(true, this.grid.getPad().getPadWidthEditable(), changeListener);
        padWidthLabel.setLabelFor(this.padWidth);
        JLabel pinLabel = new JLabel("Pin");
        JLabel pinDiameterLabel = new JLabel("Diameter");
        this.pinDiameter = new EditableJSpinner(true, this.grid.getPin().getPinDiameterEditable(), changeListener);
        pinDiameterLabel.setLabelFor(this.pinDiameter);
        JLabel holeDiameterLabel = new JLabel("Hole Diameter");
        this.holeDiameter = new EditableJSpinner(true, this.grid.getPin().getHoleDiameterEditable(), changeListener);
        holeDiameterLabel.setLabelFor(this.holeDiameter);
        JLabel xLabel = new JLabel("X");
        JLabel xCountLabel = new JLabel("Count");
        this.xCount = new EditableJSpinner(true, this.grid.getXCountEditable(), changeListener);
        xCountLabel.setLabelFor(this.xCount);
        JLabel xPitchLabel = new JLabel("Pitch");
        this.xPitch = new EditableJSpinner(true, this.grid.getXPitchEditable(), changeListener);
        xPitchLabel.setLabelFor(this.xPitch);
        JLabel yLabel = new JLabel("Y");
        JLabel yCountLabel = new JLabel("Count");
        this.yCount = new EditableJSpinner(true, this.grid.getYCountEditable(), changeListener);
        yCountLabel.setLabelFor(this.yCount);
        JLabel yPitchLabel = new JLabel("Pitch");
        this.yPitch = new EditableJSpinner(true, this.grid.getYPitchEditable(), changeListener);
        yPitchLabel.setLabelFor(this.yPitch);
        JLabel pinNumberTypeLabel = new JLabel("Pin Number Type");
        this.pinNumberType = new EditableJComboBox(this.grid.getPinNumberTypeEditable(), changeListener);
        pinNumberTypeLabel.setLabelFor(this.pinNumberType);
        if (packageType == PackageType.GRID) {
            this.pinDiameter.setEnabled(false);
            this.holeDiameter.setEnabled(false);
        } else if (packageType == PackageType.GRID_PIN) {
            this.padWidth.setEnabled(false);
        }
        layout.linkSize(0, padWidthLabel);
        layout.linkSize(0, pinDiameterLabel, holeDiameterLabel);
        layout.linkSize(0, xCountLabel, xPitchLabel);
        layout.linkSize(0, yCountLabel, yPitchLabel);
        layout.linkSize(0, pinNumberTypeLabel);
        layout.linkSize(0, padWidthLabel, pinDiameterLabel, xCountLabel, yCountLabel, pinNumberTypeLabel);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createParallelGroup().addComponent(padLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(padWidthLabel)).addGroup(layout.createParallelGroup().addComponent(this.padWidth)))).addGroup(layout.createParallelGroup().addComponent(pinLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(pinDiameterLabel).addComponent(holeDiameterLabel)).addGroup(layout.createParallelGroup().addComponent(this.pinDiameter).addComponent(this.holeDiameter)))).addGroup(layout.createParallelGroup().addComponent(xLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(xCountLabel).addComponent(xPitchLabel)).addGroup(layout.createParallelGroup().addComponent(this.xCount).addComponent(this.xPitch)))).addGroup(layout.createParallelGroup().addComponent(yLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(yCountLabel).addComponent(yPitchLabel)).addGroup(layout.createParallelGroup().addComponent(this.yCount).addComponent(this.yPitch)))).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(pinNumberTypeLabel)).addGroup(layout.createParallelGroup().addComponent(this.pinNumberType)))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createSequentialGroup().addComponent(padLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(padWidthLabel).addComponent(this.padWidth))).addGroup(layout.createSequentialGroup().addComponent(pinLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(pinDiameterLabel).addComponent(this.pinDiameter)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(holeDiameterLabel).addComponent(this.holeDiameter))).addGroup(layout.createSequentialGroup().addComponent(xLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(xCountLabel).addComponent(this.xCount)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(xPitchLabel).addComponent(this.xPitch))).addGroup(layout.createSequentialGroup().addComponent(yLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(yCountLabel).addComponent(this.yCount)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(yPitchLabel).addComponent(this.yPitch))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(pinNumberTypeLabel).addComponent(this.pinNumberType))));
    }

    @Override
    public void fillFootprint(Footprint footprint) {
        this.grid.fillFootprint(footprint);
    }

    @Override
    public void setUnitType(UnitType unitType) {
        this.padWidth.setUnitType(unitType);
        this.pinDiameter.setUnitType(unitType);
        this.holeDiameter.setUnitType(unitType);
        this.xPitch.setUnitType(unitType);
        this.yPitch.setUnitType(unitType);
    }
}

