/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.editable;

import java.util.ArrayList;
import java.util.EnumMap;
import org.cyclerecorder.footprintbuilder.data.BoundingRectangle;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.Group;
import org.cyclerecorder.footprintbuilder.data.Line;
import org.cyclerecorder.footprintbuilder.data.SegmentLine;
import org.cyclerecorder.footprintbuilder.data.SilkLine;
import org.cyclerecorder.footprintbuilder.data.SilkMarkerType;
import org.cyclerecorder.footprintbuilder.data.StyleType;
import org.cyclerecorder.footprintbuilder.editable.EditableDouble;
import org.cyclerecorder.footprintbuilder.editable.EditableEnum;

public class SilkEditable {
    private StyleType silkStyle = StyleType.RECTANGLE;
    private final EditableEnum<SilkMarkerType> silkMarker = new EditableEnum((Enum[])SilkMarkerType.values(), (Enum)SilkMarkerType.NONE);
    private final EditableDouble silkOffset = new EditableDouble();
    private final EditableDouble silkWidth = new EditableDouble();
    private final EditableDouble silkLength = new EditableDouble();
    private final EditableDouble silkX = new EditableDouble();
    private final EditableDouble silkY = new EditableDouble();

    public boolean isValid() {
        return this.getSilkOffset() > 0.0 || this.getSilkWidth() > 0.0 && this.getSilkLength() > 0.0;
    }

    public StyleType getSilkStyle() {
        return this.silkStyle;
    }

    public void setSilkStyle(StyleType silkStyle) {
        this.silkStyle = silkStyle;
    }

    public SilkMarkerType getSilkMarker() {
        return this.silkMarker.getValue();
    }

    public EditableEnum<SilkMarkerType> getSilkMarkerEditable() {
        return this.silkMarker;
    }

    public double getSilkOffset() {
        return this.silkOffset.doubleValue();
    }

    public EditableDouble getSilkOffsetEditable() {
        return this.silkOffset;
    }

    public double getSilkWidth() {
        return this.silkWidth.doubleValue();
    }

    public EditableDouble getSilkWidthEditable() {
        return this.silkWidth;
    }

    public double getSilkLength() {
        return this.silkLength.doubleValue();
    }

    public EditableDouble getSilkLengthEditable() {
        return this.silkLength;
    }

    public double getSilkX() {
        return this.silkX.doubleValue();
    }

    public EditableDouble getSilkXEditable() {
        return this.silkX;
    }

    public double getSilkY() {
        return this.silkY.doubleValue();
    }

    public EditableDouble getSilkYEditable() {
        return this.silkY;
    }

    public void fillFootprint(Footprint footprint) {
        if (!this.isValid()) {
            return;
        }
        EnumMap<Group, BoundingRectangle> groupBounds = footprint.buildGroupBounds(footprint.getOptions().getSilkLineWidth() / 2.0);
        ArrayList<SilkLine> newSilkLines = new ArrayList<SilkLine>();
        ArrayList<BoundingRectangle> bounds = new ArrayList<BoundingRectangle>();
        this.drawSilk(footprint, newSilkLines, bounds, groupBounds);
        for (SilkLine silkLine : newSilkLines) {
            SegmentLine segmentLine = new SegmentLine(silkLine.getX1(), silkLine.getY1(), silkLine.getX2(), silkLine.getY2());
            segmentLine.splitLine(bounds);
            for (Line line : segmentLine.getLines()) {
                footprint.addSilkLine(new SilkLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), silkLine.getThickness()));
            }
        }
    }

    private void drawSilk(Footprint footprint, ArrayList<SilkLine> silkLines, ArrayList<BoundingRectangle> bounds, EnumMap<Group, BoundingRectangle> groupBounds) {
        double eb;
        double et;
        double er;
        double el;
        double lineWidth = footprint.getOptions().getSilkLineWidth();
        if (this.getSilkOffset() > 0.0) {
            double silkOffset = this.getSilkOffset();
            BoundingRectangle allBR = groupBounds.get((Object)Group.ALL);
            el = allBR.getLeft() + -silkOffset;
            er = allBR.getRight() + silkOffset;
            et = allBR.getTop() + -silkOffset;
            eb = allBR.getBottom() + silkOffset;
        } else {
            double halfWidth = this.getSilkWidth() / 2.0;
            double halfLength = this.getSilkLength() / 2.0;
            double x = this.getSilkX();
            double y = this.getSilkY();
            el = -halfWidth + x;
            er = halfWidth + x;
            et = -halfLength + y;
            eb = halfLength + y;
        }
        double markerOffset = lineWidth * 3.0;
        silkLines.add(new SilkLine(el, et, er, et, lineWidth));
        silkLines.add(new SilkLine(er, et, er, eb, lineWidth));
        silkLines.add(new SilkLine(er, eb, el, eb, lineWidth));
        silkLines.add(new SilkLine(el, eb, el, et, lineWidth));
        switch (this.getSilkMarker()) {
            case NONE: {
                break;
            }
            case BEVELED: {
                silkLines.add(new SilkLine(el, eb - markerOffset, el + markerOffset, eb, lineWidth));
                break;
            }
            case SQUARE: {
                silkLines.add(new SilkLine(el, eb - markerOffset, el + markerOffset, eb - markerOffset, lineWidth));
                silkLines.add(new SilkLine(el + markerOffset, eb - markerOffset, el + markerOffset, eb, lineWidth));
                break;
            }
            case CUP: {
                silkLines.add(new SilkLine(el, 0.0 + markerOffset, el + markerOffset, 0.0 + markerOffset, lineWidth));
                silkLines.add(new SilkLine(el + markerOffset, 0.0 + markerOffset, el + markerOffset, 0.0 - markerOffset, lineWidth));
                silkLines.add(new SilkLine(el, 0.0 - markerOffset, el + markerOffset, 0.0 - markerOffset, lineWidth));
                break;
            }
            case BAND: {
                BoundingRectangle pinOneBR = groupBounds.get((Object)Group.PINONE);
                double top = pinOneBR.getTop();
                silkLines.add(new SilkLine(el, top, er, top, lineWidth));
                break;
            }
            case AROUNDPINONE: {
                BoundingRectangle pinOneBR = groupBounds.get((Object)Group.PINONE);
                double left = pinOneBR.getLeft();
                double right = pinOneBR.getRight();
                double top = pinOneBR.getTop();
                double bottom = pinOneBR.getBottom();
                silkLines.add(new SilkLine(left, top, right, top, lineWidth));
                silkLines.add(new SilkLine(right, top, right, bottom, lineWidth));
                silkLines.add(new SilkLine(right, bottom, left, bottom, lineWidth));
                silkLines.add(new SilkLine(left, bottom, left, top, lineWidth));
                break;
            }
            case INSIDE_DOT: {
                silkLines.add(new SilkLine(el + markerOffset, eb - markerOffset, el + markerOffset, eb - markerOffset, lineWidth * 2.0));
                break;
            }
            case OUTSIDE_DOT: {
                silkLines.add(new SilkLine(el - markerOffset, eb + markerOffset, el - markerOffset, eb + markerOffset, lineWidth * 2.0));
                break;
            }
            case INSIDE_TICK: {
                silkLines.add(new SilkLine(el, eb, el + markerOffset, eb - markerOffset, lineWidth));
                break;
            }
            case OUTSIDE_TICK: {
                silkLines.add(new SilkLine(el, eb, el - markerOffset, eb + markerOffset, lineWidth));
                break;
            }
            case INSIDE_LINE: {
                silkLines.add(new SilkLine(el, eb - markerOffset, er, eb - markerOffset, lineWidth));
                break;
            }
            case OUTSIDE_LINE: {
                silkLines.add(new SilkLine(el, eb + markerOffset, er, eb + markerOffset, lineWidth));
            }
        }
        for (Group group : new Group[]{Group.TOP, Group.BOTTOM, Group.LEFT, Group.RIGHT, Group.EXPOSEDPAD, Group.GRID}) {
            BoundingRectangle br = groupBounds.get((Object)group);
            if (br == null) continue;
            bounds.add(br);
        }
    }
}

