/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.editable;

import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.Group;
import org.cyclerecorder.footprintbuilder.data.OffsetType;
import org.cyclerecorder.footprintbuilder.data.PadPin;
import org.cyclerecorder.footprintbuilder.data.StyleType;
import org.cyclerecorder.footprintbuilder.editable.EditableDouble;
import org.cyclerecorder.footprintbuilder.editable.EditableEnum;
import org.cyclerecorder.footprintbuilder.editable.EditableInteger;
import org.cyclerecorder.footprintbuilder.editable.OptionsEditable;
import org.cyclerecorder.footprintbuilder.editable.PadEditable;

public class RectangleEditable {
    private final SideEditable bSide = new SideEditable(){

        @Override
        protected void fillFootprint(Footprint footprint, double halfOffset) {
            int count = this.getCount();
            double pitch = this.getPitch();
            double x = -(pitch * (double)(count - 1) / 2.0);
            double y = halfOffset;
            for (int i = 0; i < count; ++i) {
                PadPin padPin = new PadPin(x, y, RectangleEditable.this.getNextNumber());
                RectangleEditable.fillPadPin(padPin, this.getPad(), 180.0, this.getOffsetType(), footprint.getOptions());
                footprint.addGroup(Group.ALL, padPin);
                footprint.addGroup(Group.BOTTOM, padPin);
                x += pitch;
            }
        }
    };
    private final SideEditable rSide = new SideEditable(){

        @Override
        protected void fillFootprint(Footprint footprint, double halfOffset) {
            int count = this.getCount();
            double pitch = this.getPitch();
            double x = halfOffset;
            double y = pitch * (double)(count - 1) / 2.0;
            for (int i = 0; i < count; ++i) {
                PadPin padPin = new PadPin(x, y, RectangleEditable.this.getNextNumber());
                RectangleEditable.fillPadPin(padPin, this.getPad(), 90.0, this.getOffsetType(), footprint.getOptions());
                footprint.addGroup(Group.ALL, padPin);
                footprint.addGroup(Group.RIGHT, padPin);
                y -= pitch;
            }
        }
    };
    private final SideEditable tSide = new SideEditable(){

        @Override
        protected void fillFootprint(Footprint footprint, double halfOffset) {
            int count = this.getCount();
            double pitch = this.getPitch();
            double x = pitch * (double)(count - 1) / 2.0;
            double y = -halfOffset;
            for (int i = 0; i < count; ++i) {
                PadPin padPin = new PadPin(x, y, RectangleEditable.this.getNextNumber());
                RectangleEditable.fillPadPin(padPin, this.getPad(), 0.0, this.getOffsetType(), footprint.getOptions());
                footprint.addGroup(Group.ALL, padPin);
                footprint.addGroup(Group.TOP, padPin);
                x -= pitch;
            }
        }
    };
    private final SideEditable lSide = new SideEditable(){

        @Override
        protected void fillFootprint(Footprint footprint, double halfOffset) {
            int count = this.getCount();
            double pitch = this.getPitch();
            double x = -halfOffset;
            double y = -(pitch * (double)(count - 1) / 2.0);
            for (int i = 0; i < count; ++i) {
                PadPin padPin = new PadPin(x, y, RectangleEditable.this.getNextNumber());
                RectangleEditable.fillPadPin(padPin, this.getPad(), 270.0, this.getOffsetType(), footprint.getOptions());
                footprint.addGroup(Group.ALL, padPin);
                footprint.addGroup(Group.LEFT, padPin);
                y += pitch;
            }
        }
    };
    private final EditableDouble verticalOffset = new EditableDouble();
    private final EditableDouble horizontalOffset = new EditableDouble();
    private final PadEditable epad = new PadEditable();
    private int number;

    public SideEditable getBSide() {
        return this.bSide;
    }

    public SideEditable getRSide() {
        return this.rSide;
    }

    public SideEditable getTSide() {
        return this.tSide;
    }

    public SideEditable getLSide() {
        return this.lSide;
    }

    public double getVerticalOffset() {
        return this.verticalOffset.doubleValue();
    }

    public EditableDouble getVerticalOffsetEditable() {
        return this.verticalOffset;
    }

    public double getHorizontalOffset() {
        return this.horizontalOffset.doubleValue();
    }

    public EditableDouble getHorizontalOffsetEditable() {
        return this.horizontalOffset;
    }

    public PadEditable getEPad() {
        return this.epad;
    }

    public void fillFootprint(Footprint footprint) {
        this.number = 1;
        double halfVOffset = this.getVerticalOffset() / 2.0;
        double halfHOffset = this.getHorizontalOffset() / 2.0;
        this.getBSide().fillFootprint(footprint, halfVOffset);
        this.getRSide().fillFootprint(footprint, halfHOffset);
        this.getTSide().fillFootprint(footprint, halfVOffset);
        this.getLSide().fillFootprint(footprint, halfHOffset);
        if (this.epad.isValid()) {
            PadPin padPin = new PadPin(0.0, 0.0, "EP");
            RectangleEditable.fillPadPin(padPin, this.epad, 0.0, OffsetType.CENTRED, footprint.getOptions());
            footprint.addGroup(Group.ALL, padPin);
            footprint.addGroup(Group.EXPOSEDPAD, padPin);
        }
    }

    private static void fillPadPin(PadPin padPin, PadEditable pad, double angle, OffsetType offsetType, OptionsEditable options) {
        StyleType style = pad.getPadStyle();
        padPin.setPad(true);
        padPin.setPadWidth(pad.getPadWidth());
        padPin.setPadLength(style != StyleType.SQUARE ? pad.getPadLength() : pad.getPadWidth());
        padPin.setRectangle(style == StyleType.RECTANGLE || style == StyleType.SQUARE);
        padPin.setAngle(angle);
        padPin.setMaskOffset(options.getMaskOffset());
        padPin.setClearanceOffset(options.getClearanceOffset());
        padPin.setYOffset(offsetType.getOffset(padPin.getPadLength() / 2.0));
    }

    private String getNextNumber() {
        return Integer.toString(this.number++);
    }

    public abstract class SideEditable {
        private final PadEditable pad = new PadEditable();
        private final EditableInteger count = new EditableInteger();
        private final EditableDouble pitch = new EditableDouble();
        private final EditableEnum<OffsetType> offsetType = new EditableEnum((Enum[])OffsetType.values(), (Enum)OffsetType.CENTRED);

        public PadEditable getPad() {
            return this.pad;
        }

        public int getCount() {
            return this.count.intValue();
        }

        public EditableInteger getCountEditable() {
            return this.count;
        }

        public double getPitch() {
            return this.pitch.doubleValue();
        }

        public EditableDouble getPitchEditable() {
            return this.pitch;
        }

        public OffsetType getOffsetType() {
            return this.offsetType.getValue();
        }

        public EditableEnum<OffsetType> getOffsetTypeEditable() {
            return this.offsetType;
        }

        protected abstract void fillFootprint(Footprint var1, double var2);
    }
}

