/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.editable;

import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.Group;
import org.cyclerecorder.footprintbuilder.data.OffsetType;
import org.cyclerecorder.footprintbuilder.data.PadPin;
import org.cyclerecorder.footprintbuilder.data.StyleType;
import org.cyclerecorder.footprintbuilder.editable.EditableDouble;
import org.cyclerecorder.footprintbuilder.editable.EditableEnum;
import org.cyclerecorder.footprintbuilder.editable.EditableInteger;
import org.cyclerecorder.footprintbuilder.editable.OptionsEditable;
import org.cyclerecorder.footprintbuilder.editable.PadEditable;

public class QuadEditable {
    private final PadEditable xPad = new PadEditable();
    private final PadEditable yPad = new PadEditable();
    private final PadEditable ePad = new PadEditable();
    private boolean square;
    private final EditableInteger xCount = new EditableInteger();
    private final EditableInteger yCount = new EditableInteger();
    private final EditableDouble xPitch = new EditableDouble();
    private final EditableDouble yPitch = new EditableDouble();
    private final EditableDouble horizontalPitch = new EditableDouble();
    private final EditableDouble verticalPitch = new EditableDouble();
    private final EditableEnum<OffsetType> offsetType = new EditableEnum((Enum[])OffsetType.values(), (Enum)OffsetType.CENTRED);

    public PadEditable getXPad() {
        return this.xPad;
    }

    public PadEditable getYPad() {
        return this.yPad;
    }

    public PadEditable getEPad() {
        return this.ePad;
    }

    public boolean isSquare() {
        return this.square;
    }

    public void setSquare(boolean square) {
        this.square = square;
    }

    public int getXCount() {
        return this.xCount.intValue();
    }

    public EditableInteger getXCountEditable() {
        return this.xCount;
    }

    public int getYCount() {
        return this.yCount.intValue();
    }

    public EditableInteger getYCountEditable() {
        return this.yCount;
    }

    public double getXPitch() {
        return this.xPitch.doubleValue();
    }

    public EditableDouble getXPitchEditable() {
        return this.xPitch;
    }

    public double getYPitch() {
        return this.yPitch.doubleValue();
    }

    public EditableDouble getYPitchEditable() {
        return this.yPitch;
    }

    public double getHorizontalPitch() {
        return this.horizontalPitch.doubleValue();
    }

    public EditableDouble getHorizontalPitchEditable() {
        return this.horizontalPitch;
    }

    public double getVerticalPitch() {
        return this.verticalPitch.doubleValue();
    }

    public EditableDouble getVerticalPitchEditable() {
        return this.verticalPitch;
    }

    public OffsetType getOffsetType() {
        return this.offsetType.getValue();
    }

    public EditableEnum<OffsetType> getOffsetTypeEditable() {
        return this.offsetType;
    }

    public void fillFootprint(Footprint footprint) {
        int iy;
        PadPin padPin;
        String num;
        int ix;
        OptionsEditable options = footprint.getOptions();
        int xcount = this.getXCount();
        int ycount = !this.isSquare() ? this.getYCount() : xcount;
        double xpitch = this.getXPitch();
        double ypitch = !this.isSquare() ? this.getYPitch() : xpitch;
        double vpitch = this.getVerticalPitch();
        double hpitch = !this.isSquare() ? this.getHorizontalPitch() : vpitch;
        PadEditable xpad = this.getXPad();
        PadEditable ypad = !this.isSquare() ? this.getYPad() : xpad;
        PadEditable epad = this.getEPad();
        OffsetType offsetType = this.getOffsetType();
        int number = 1;
        double x = -(xpitch * (double)(xcount - 1) / 2.0);
        double y = vpitch / 2.0;
        for (ix = 0; ix < xcount; ++ix) {
            num = Integer.toString(number++);
            padPin = new PadPin(x, y, num);
            QuadEditable.fillPadPin(padPin, xpad, 180.0, offsetType, options);
            footprint.addGroup(Group.ALL, padPin);
            footprint.addGroup(Group.BOTTOM, padPin);
            if (number - 1 == 1) {
                footprint.addGroup(Group.PINONE, padPin);
            }
            x += xpitch;
        }
        x = hpitch / 2.0;
        y = ypitch * (double)(ycount - 1) / 2.0;
        for (iy = 0; iy < ycount; ++iy) {
            num = Integer.toString(number++);
            padPin = new PadPin(x, y, num);
            QuadEditable.fillPadPin(padPin, ypad, 90.0, offsetType, options);
            footprint.addGroup(Group.ALL, padPin);
            footprint.addGroup(Group.RIGHT, padPin);
            y -= ypitch;
        }
        x = xpitch * (double)(xcount - 1) / 2.0;
        y = -(vpitch / 2.0);
        for (ix = 0; ix < xcount; ++ix) {
            num = Integer.toString(number++);
            padPin = new PadPin(x, y, num);
            QuadEditable.fillPadPin(padPin, xpad, 0.0, offsetType, options);
            footprint.addGroup(Group.ALL, padPin);
            footprint.addGroup(Group.TOP, padPin);
            x -= xpitch;
        }
        x = -(hpitch / 2.0);
        y = -(ypitch * (double)(ycount - 1) / 2.0);
        for (iy = 0; iy < ycount; ++iy) {
            num = Integer.toString(number++);
            padPin = new PadPin(x, y, num);
            QuadEditable.fillPadPin(padPin, ypad, 270.0, offsetType, options);
            footprint.addGroup(Group.ALL, padPin);
            footprint.addGroup(Group.LEFT, padPin);
            y += ypitch;
        }
        if (epad.isValid()) {
            PadPin padPin2 = new PadPin(0.0, 0.0, "EP");
            QuadEditable.fillPadPin(padPin2, epad, 0.0, OffsetType.CENTRED, options);
            footprint.addGroup(Group.ALL, padPin2);
            footprint.addGroup(Group.EXPOSEDPAD, padPin2);
        }
    }

    private static void fillPadPin(PadPin padPin, PadEditable pad, double angle, OffsetType offsetType, OptionsEditable options) {
        StyleType style = pad.getPadStyle();
        padPin.setPad(true);
        padPin.setPadWidth(pad.getPadWidth());
        padPin.setPadLength(style != StyleType.SQUARE ? pad.getPadLength() : pad.getPadWidth());
        padPin.setRectangle(style == StyleType.RECTANGLE || style == StyleType.SQUARE);
        padPin.setAngle(angle);
        padPin.setMaskOffset(options.getMaskOffset());
        padPin.setClearanceOffset(options.getClearanceOffset());
        padPin.setYOffset(offsetType.getOffset(padPin.getPadLength() / 2.0));
    }
}

