/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.editable;

import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.Group;
import org.cyclerecorder.footprintbuilder.data.PadPin;
import org.cyclerecorder.footprintbuilder.data.PinNumberType;
import org.cyclerecorder.footprintbuilder.data.StyleType;
import org.cyclerecorder.footprintbuilder.editable.EditableDouble;
import org.cyclerecorder.footprintbuilder.editable.EditableEnum;
import org.cyclerecorder.footprintbuilder.editable.EditableInteger;
import org.cyclerecorder.footprintbuilder.editable.OptionsEditable;
import org.cyclerecorder.footprintbuilder.editable.PadEditable;
import org.cyclerecorder.footprintbuilder.editable.PinEditable;

public class GridEditable {
    private static final char[] ALPHANUMBERS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'T', 'U', 'V', 'W', 'Y'};
    private final PadEditable pad = new PadEditable();
    private final PinEditable pin = new PinEditable();
    private final EditableInteger xCount = new EditableInteger();
    private final EditableInteger yCount = new EditableInteger();
    private final EditableDouble xPitch = new EditableDouble();
    private final EditableDouble yPitch = new EditableDouble();
    private final EditableEnum<PinNumberType> pinNumberType = new EditableEnum((Enum[])PinNumberType.values(), (Enum)PinNumberType.NUMERIC);

    public PadEditable getPad() {
        return this.pad;
    }

    public PinEditable getPin() {
        return this.pin;
    }

    public int getXCount() {
        return this.xCount.intValue();
    }

    public EditableInteger getXCountEditable() {
        return this.xCount;
    }

    public int getYCount() {
        return this.yCount.intValue();
    }

    public EditableInteger getYCountEditable() {
        return this.yCount;
    }

    public double getXPitch() {
        return this.xPitch.doubleValue();
    }

    public EditableDouble getXPitchEditable() {
        return this.xPitch;
    }

    public double getYPitch() {
        return this.yPitch.doubleValue();
    }

    public EditableDouble getYPitchEditable() {
        return this.yPitch;
    }

    public PinNumberType getPinNumberType() {
        return this.pinNumberType.getValue();
    }

    public EditableEnum<PinNumberType> getPinNumberTypeEditable() {
        return this.pinNumberType;
    }

    public void fillFootprint(Footprint footprint) {
        OptionsEditable options = footprint.getOptions();
        int xcount = this.getXCount();
        int ycount = this.getYCount();
        double xpitch = this.getXPitch();
        double ypitch = this.getYPitch();
        boolean isPad = this.getPad().isValid();
        boolean isPin = this.getPin().isValid();
        PinNumberType pinNumberType = this.getPinNumberType();
        int number = 1;
        double y = ypitch * (double)(ycount - 1) / 2.0;
        for (int iy = 0; iy < ycount; ++iy) {
            double x = -(xpitch * (double)(xcount - 1) / 2.0);
            for (int ix = 0; ix < xcount; ++ix) {
                String num = pinNumberType.getPinNumber(number++, ix, iy);
                PadPin padPin = new PadPin(x, y, num);
                if (isPad) {
                    GridEditable.fillPad(padPin, this.pad, options);
                }
                if (isPin) {
                    GridEditable.fillPin(padPin, this.pin, options);
                }
                footprint.addGroup(Group.ALL, padPin);
                footprint.addGroup(Group.GRID, padPin);
                if (number - 1 == 1) {
                    footprint.addGroup(Group.PINONE, padPin);
                }
                x += xpitch;
            }
            y -= ypitch;
        }
    }

    private static void fillPad(PadPin padPin, PadEditable pad, OptionsEditable options) {
        StyleType style = pad.getPadStyle();
        padPin.setPad(true);
        padPin.setPadWidth(pad.getPadWidth());
        padPin.setPadLength(style == StyleType.SQUARE || style == StyleType.CIRCLE ? pad.getPadWidth() : pad.getPadLength());
        padPin.setRectangle(style == StyleType.RECTANGLE || style == StyleType.SQUARE);
        padPin.setMaskOffset(options.getMaskOffset());
        padPin.setClearanceOffset(options.getClearanceOffset());
    }

    private static void fillPin(PadPin padPin, PinEditable pin, OptionsEditable options) {
        padPin.setPin(true);
        padPin.setPinDiameter(pin.getPinDiameter());
        padPin.setHoleDiameter(pin.getHoleDiameter());
        padPin.setMaskOffset(options.getMaskOffset());
        padPin.setClearanceOffset(options.getClearanceOffset());
    }
}

