/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.data;

public enum UnitType {
    MM("mm", 39.37007874),
    MIL("mil", 1.0),
    INCH("inch", 1000.0);

    private final String description;
    private final double mils;

    private UnitType(String description, double mils) {
        this.description = description;
        this.mils = mils;
    }

    public String toString() {
        return this.description;
    }

    public double toMil(double value) {
        return value * this.mils;
    }

    public double toDeciMil(double value) {
        return value * (this.mils * 10.0);
    }

    public double toCentiMil(double value) {
        return value * (this.mils * 100.0);
    }

    public static double convert(UnitType from, double value, UnitType to) {
        if (from == null) {
            return 0.0;
        }
        if (from == to) {
            return value;
        }
        return value * from.mils / to.mils;
    }
}

