/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.data;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.cyclerecorder.footprintbuilder.data.BoundingRectangle;
import org.cyclerecorder.footprintbuilder.data.Line;
import org.cyclerecorder.footprintbuilder.data.Point;

public final class SegmentLine {
    private final Comparator<Segment> comparator = new Comparator<Segment>(){

        @Override
        public int compare(Segment o1, Segment o2) {
            return o1.point.compareTo(o2.point);
        }
    };
    private final TreeSet<Segment> segments = new TreeSet<Segment>(this.comparator);
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;

    public SegmentLine(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.add(x1, y1, x2, y2);
    }

    public void add(double x1, double y1, double x2, double y2) {
        Point p1 = new Point(x1, y1);
        Point p2 = new Point(x2, y2);
        this.add(p1, p2);
    }

    public void add(Point p1, Point p2) {
        Point from = p1;
        Point to = p2;
        if (p1.compareTo(p2) > 0) {
            from = p2;
            to = p1;
        }
        Segment segFrom = new Segment(from, true);
        Segment segTo = new Segment(to, false);
        this.apply(segFrom, segTo);
    }

    public void remove(double x1, double y1, double x2, double y2) {
        Point p1 = new Point(x1, y1);
        Point p2 = new Point(x2, y2);
        this.remove(p1, p2);
    }

    public void remove(Point p1, Point p2) {
        Point from = p1;
        Point to = p2;
        if (p1.compareTo(p2) > 0) {
            from = p2;
            to = p1;
        }
        Segment segFrom = new Segment(from, false);
        Segment segTo = new Segment(to, false);
        this.apply(segFrom, segTo);
    }

    private void apply(Segment segFrom, Segment segTo) {
        NavigableSet<Segment> subSet = this.segments.subSet(segFrom, true, segTo, true);
        if (subSet.isEmpty()) {
            Segment s = this.segments.floor(segTo);
            if (s != null) {
                segTo.line = s.line;
            }
            this.segments.add(segFrom);
            this.segments.add(segTo);
        } else if (subSet.size() > 0) {
            Segment s = this.segments.floor(segTo);
            segTo.line = s.line;
            subSet.clear();
            this.segments.add(segFrom);
            this.segments.add(segTo);
        }
    }

    public void clear() {
        this.segments.clear();
    }

    public ArrayList<Line> getLines() {
        ArrayList<Line> lines = new ArrayList<Line>();
        Point point = null;
        for (Segment segment : this.segments) {
            if (point != null) {
                lines.add(new Line(point, segment.point));
                point = null;
            }
            if (!segment.line) continue;
            point = segment.point;
        }
        if (point != null) {
            lines.add(new Line(point, point));
            point = null;
        }
        return lines;
    }

    public String toString() {
        return this.segments.toString() + " => " + this.getLines();
    }

    public void splitLine(ArrayList<BoundingRectangle> bounds) {
        boolean vertical;
        boolean horizontal = this.y1 == this.y2;
        boolean bl = vertical = this.x1 == this.x2;
        if (horizontal && vertical) {
            for (BoundingRectangle bound : bounds) {
                double l = bound.getLeft();
                double r = bound.getRight();
                double t = bound.getTop();
                double b = bound.getBottom();
                if (!(this.x1 > l) || !(this.x1 < r) || !(this.y1 > t) || !(this.y1 < b)) continue;
                this.clear();
            }
        } else if (horizontal) {
            for (BoundingRectangle bound : bounds) {
                double l = bound.getLeft();
                double r = bound.getRight();
                double t = bound.getTop();
                double b = bound.getBottom();
                if (!(this.y1 > t) || !(this.y1 < b)) continue;
                this.remove(new Point(l, this.y1), new Point(r, this.y1));
            }
        } else if (vertical) {
            for (BoundingRectangle bound : bounds) {
                double l = bound.getLeft();
                double r = bound.getRight();
                double t = bound.getTop();
                double b = bound.getBottom();
                if (!(this.x1 > l) || !(this.x1 < r)) continue;
                this.remove(new Point(this.x1, t), new Point(this.x1, b));
            }
        } else {
            double _m = (this.y2 - this.y1) / (this.x2 - this.x1);
            double _b = this.y1 - this.x1 * _m;
            for (BoundingRectangle bound : bounds) {
                double l = bound.getLeft();
                double r = bound.getRight();
                double t = bound.getTop();
                double b = bound.getBottom();
                if (this.x1 < l && this.x2 < l || this.x1 > r && this.x2 > r || this.y1 < t && this.y2 < t || this.y1 > b && this.y2 > b) continue;
                Point pl = null;
                double yl = _m * l + _b;
                if (yl >= t && yl <= b) {
                    pl = new Point(l, yl);
                }
                Point pr = null;
                double yr = _m * r + _b;
                if (yr >= t && yr <= b) {
                    pr = new Point(r, yr);
                }
                Point pt = null;
                double xt = (t - _b) / _m;
                if (xt >= l && xt <= r) {
                    pt = new Point(xt, t);
                }
                Point pb = null;
                double xb = (b - _b) / _m;
                if (xb >= l && xb <= r) {
                    pb = new Point(xb, b);
                }
                if (pl != null && pr != null) {
                    this.remove(pl, pr);
                    continue;
                }
                if (pl != null && pt != null) {
                    this.remove(pl, pt);
                    continue;
                }
                if (pl != null && pb != null) {
                    this.remove(pl, pb);
                    continue;
                }
                if (pr != null && pt != null) {
                    this.remove(pr, pt);
                    continue;
                }
                if (pr != null && pb != null) {
                    this.remove(pr, pb);
                    continue;
                }
                if (pt == null || pb == null) continue;
                this.remove(pt, pb);
            }
        }
    }

    private static final class Segment {
        private final Point point;
        private boolean line;

        private Segment(Point point, boolean line) {
            this.point = point;
            this.line = line;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.line ? "Line" : "Hole").append(this.point);
            return builder.toString();
        }
    }
}

