/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.data;

import org.cyclerecorder.footprintbuilder.Utility;
import org.cyclerecorder.footprintbuilder.data.BoundingRectangle;
import org.cyclerecorder.footprintbuilder.data.Point;

public final class Quadrilateral {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private double x3;
    private double y3;
    private double x4;
    private double y4;

    public Quadrilateral() {
    }

    public Quadrilateral(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        this.setP1(x1, y1);
        this.setP2(x2, y2);
        this.setP3(x3, y3);
        this.setP4(x4, y4);
    }

    public Quadrilateral(Point p1, Point p2, Point p3, Point p4) {
        this.setP1(p1.getX(), p1.getY());
        this.setP2(p2.getX(), p2.getY());
        this.setP3(p3.getX(), p3.getY());
        this.setP4(p4.getX(), p4.getY());
    }

    public void setP1(double x, double y) {
        this.x1 = x;
        this.y1 = y;
    }

    public void setP2(double x, double y) {
        this.x2 = x;
        this.y2 = y;
    }

    public void setP3(double x, double y) {
        this.x3 = x;
        this.y3 = y;
    }

    public void setP4(double x, double y) {
        this.x4 = x;
        this.y4 = y;
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    public double getX3() {
        return this.x3;
    }

    public double getY3() {
        return this.y3;
    }

    public double getX4() {
        return this.x4;
    }

    public double getY4() {
        return this.y4;
    }

    public void rotate(double angle) {
        double cos = Utility.getCosOfDegrees(angle);
        double sin = Utility.getSinOfDegrees(angle);
        double _x = this.x1;
        double _y = this.y1;
        this.x1 = cos * _x + -sin * _y;
        this.y1 = sin * _x + cos * _y;
        _x = this.x2;
        _y = this.y2;
        this.x2 = cos * _x + -sin * _y;
        this.y2 = sin * _x + cos * _y;
        _x = this.x3;
        _y = this.y3;
        this.x3 = cos * _x + -sin * _y;
        this.y3 = sin * _x + cos * _y;
        _x = this.x4;
        _y = this.y4;
        this.x4 = cos * _x + -sin * _y;
        this.y4 = sin * _x + cos * _y;
    }

    public void translate(double tx, double ty) {
        this.x1 += tx;
        this.y1 += ty;
        this.x2 += tx;
        this.y2 += ty;
        this.x3 += tx;
        this.y3 += ty;
        this.x4 += tx;
        this.y4 += ty;
    }

    public void addBounds(BoundingRectangle br) {
        double xmin = Math.min(Math.min(this.x1, this.x2), Math.min(this.x3, this.x4));
        double xmax = Math.max(Math.max(this.x1, this.x2), Math.max(this.x3, this.x4));
        double ymin = Math.min(Math.min(this.y1, this.y2), Math.min(this.y3, this.y4));
        double ymax = Math.max(Math.max(this.y1, this.y2), Math.max(this.y3, this.y4));
        br.add(xmin, xmax, ymin, ymax);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.x1);
        builder.append(",").append(this.y1);
        builder.append(",").append(this.x2);
        builder.append(",").append(this.y2);
        builder.append(",").append(this.x3);
        builder.append(",").append(this.y3);
        builder.append(",").append(this.x4);
        builder.append(",").append(this.y4);
        builder.append("]");
        return builder.toString();
    }
}

