/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.data;

import org.cyclerecorder.footprintbuilder.data.Point;

public final class Line {
    private double x1;
    private double y1;
    private double x2;
    private double y2;

    public Line() {
    }

    public Line(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public Line(Line line) {
        this(line.x1, line.y1, line.x2, line.y2);
    }

    public Line(Point p1, Point p2) {
        this(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.x1);
        builder.append(",").append(this.y1);
        builder.append(",").append(this.x2);
        builder.append(",").append(this.y2);
        builder.append("]");
        return builder.toString();
    }

    public boolean isVertical() {
        return this.x1 == this.x2;
    }

    public boolean hasVerticalLength() {
        return this.y1 != this.y2;
    }

    public boolean isHorizontal() {
        return this.y1 == this.y2;
    }

    public boolean hasHorizontalLength() {
        return this.x1 != this.x2;
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }
}

