/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import org.cyclerecorder.footprintbuilder.data.BoundingRectangle;
import org.cyclerecorder.footprintbuilder.data.Group;
import org.cyclerecorder.footprintbuilder.data.OffsetType;
import org.cyclerecorder.footprintbuilder.data.PadPin;
import org.cyclerecorder.footprintbuilder.data.Quadrilateral;
import org.cyclerecorder.footprintbuilder.data.SilkLine;
import org.cyclerecorder.footprintbuilder.data.UnitType;
import org.cyclerecorder.footprintbuilder.editable.OptionsEditable;
import org.cyclerecorder.footprintbuilder.editable.RectangleEditable;
import org.cyclerecorder.footprintbuilder.editable.SilkEditable;
import org.cyclerecorder.footprintbuilder.renderer.PcbRenderer;

public final class Footprint {
    private final ArrayList<SilkLine> silkLines = new ArrayList();
    private final EnumMap<Group, ArrayList<PadPin>> groupLists = new EnumMap(Group.class);
    private final UnitType unitType;
    private final OptionsEditable options;
    private String name = "Test";
    private String description;

    public Footprint(UnitType unitType, OptionsEditable options) {
        this.unitType = unitType;
        this.options = options;
    }

    public String toString() {
        return this.groupLists + " " + this.silkLines;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public OptionsEditable getOptions() {
        return this.options;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<SilkLine> getSilkLines() {
        return this.silkLines;
    }

    public ArrayList<PadPin> getPadPins() {
        return this.getGroup(Group.ALL);
    }

    private ArrayList<PadPin> getGroup(Group group) {
        ArrayList<PadPin> groupList = this.groupLists.get((Object)group);
        if (groupList == null) {
            groupList = new ArrayList();
            this.groupLists.put(group, groupList);
        }
        return groupList;
    }

    public void addGroup(Group group, PadPin padPin) {
        this.getGroup(group).add(padPin);
    }

    public void addSilkLine(SilkLine silkLine) {
        this.silkLines.add(silkLine);
    }

    public EnumMap<Group, BoundingRectangle> buildGroupBounds(double extraOffset) {
        IdentityHashMap<PadPin, Quadrilateral> padPinBounds = new IdentityHashMap<PadPin, Quadrilateral>();
        EnumMap<Group, BoundingRectangle> groupBounds = new EnumMap<Group, BoundingRectangle>(Group.class);
        for (PadPin padPin : this.getPadPins()) {
            double x = padPin.getX();
            double y = padPin.getY();
            double xOffset = padPin.getXOffset();
            double yOffset = padPin.getYOffset();
            double angle = padPin.getAngle();
            double halfWidth = 0.0;
            double halfLength = 0.0;
            if (padPin.isPad()) {
                halfWidth = padPin.getPadWidth() / 2.0;
                halfLength = padPin.getPadLength() / 2.0;
            }
            if (padPin.isPin()) {
                double halfDiameter = Math.max(padPin.getPinDiameter(), padPin.getHoleDiameter()) / 2.0;
                halfWidth = Math.max(halfWidth, halfDiameter);
                halfLength = Math.max(halfLength, halfDiameter);
            }
            double offset = padPin.getMaskOffset() + extraOffset;
            Quadrilateral quad = new Quadrilateral();
            quad.setP1(-halfWidth + -offset, -halfLength + -offset);
            quad.setP2(halfWidth + offset, -halfLength + -offset);
            quad.setP3(halfWidth + offset, halfLength + offset);
            quad.setP4(-halfWidth + -offset, halfLength + offset);
            quad.translate(xOffset, yOffset);
            quad.rotate(angle);
            quad.translate(x, y);
            padPinBounds.put(padPin, quad);
        }
        for (Group group : this.groupLists.keySet()) {
            BoundingRectangle br = new BoundingRectangle();
            for (PadPin padPin : this.groupLists.get((Object)group)) {
                Quadrilateral quad = (Quadrilateral)padPinBounds.get(padPin);
                quad.addBounds(br);
            }
            groupBounds.put(group, br);
        }
        return groupBounds;
    }

    public static void main(String[] args) throws IOException {
        RectangleEditable qe = new RectangleEditable();
        qe.getVerticalOffsetEditable().setValue(2.5);
        qe.getTSide().getCountEditable().setValue(1);
        qe.getTSide().getPitchEditable().setValue(0.0);
        qe.getTSide().getOffsetTypeEditable().setValue(OffsetType.INSIDE);
        qe.getTSide().getPad().getPadWidthEditable().setValue(0.5);
        qe.getTSide().getPad().getPadLengthEditable().setValue(0.45);
        qe.getBSide().getCountEditable().setValue(2);
        qe.getBSide().getPitchEditable().setValue(1.9);
        qe.getBSide().getOffsetTypeEditable().setValue(OffsetType.INSIDE);
        qe.getBSide().getPad().getPadWidthEditable().setValue(0.5);
        qe.getBSide().getPad().getPadLengthEditable().setValue(0.45);
        SilkEditable se = new SilkEditable();
        se.getSilkWidthEditable().setValue(3.0);
        se.getSilkLengthEditable().setValue(1.2);
        OptionsEditable oe = new OptionsEditable();
        oe.getMaskOffsetEditable().setValue(0.05);
        oe.getClearanceOffsetEditable().setValue(0.05);
        oe.getSilkLineWidthEditable().setValue(0.1);
        Footprint footprint = new Footprint(UnitType.MM, oe);
        qe.fillFootprint(footprint);
        se.fillFootprint(footprint);
        StringBuilder builder = new StringBuilder();
        PcbRenderer pcbRenderer = new PcbRenderer();
        pcbRenderer.render(builder, footprint);
        System.out.println(builder);
    }
}

