/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder.data;

public final class BoundingRectangle {
    private double left;
    private double right;
    private double top;
    private double bottom;

    public BoundingRectangle() {
        this(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public BoundingRectangle(double left, double right, double top, double bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    public void add(double left, double right, double top, double bottom) {
        this.left = BoundingRectangle.min(this.left, left);
        this.right = BoundingRectangle.max(this.right, right);
        this.top = BoundingRectangle.min(this.top, top);
        this.bottom = BoundingRectangle.max(this.bottom, bottom);
    }

    private static double min(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        return Math.min(a, b);
    }

    private static double max(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        return Math.max(a, b);
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public double getTop() {
        return this.top;
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getWidth() {
        return this.right - this.left;
    }

    public double getLength() {
        return this.bottom - this.top;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.left);
        builder.append(",").append(this.right);
        builder.append(",").append(this.top);
        builder.append(",").append(this.bottom);
        builder.append("]");
        return builder.toString();
    }
}

