/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.cyclerecorder.footprintbuilder.FootprintEditor;
import org.cyclerecorder.footprintbuilder.FootprintView;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.PackageType;
import org.cyclerecorder.footprintbuilder.data.UnitType;
import org.cyclerecorder.footprintbuilder.renderer.AppendableRenderer;
import org.cyclerecorder.footprintbuilder.renderer.KicadRenderer;
import org.cyclerecorder.footprintbuilder.renderer.PcbRenderer;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Footprint Builder");
        frame.setDefaultCloseOperation(2);
        frame.setSize(800, 600);
        final FootprintEditor footprintEditor = new FootprintEditor();
        FootprintView footprintView = new FootprintView(footprintEditor);
        footprintEditor.setFootprintView(footprintView);
        frame.add((Component)footprintView, "Center");
        frame.add((Component)footprintEditor, "West");
        JMenuBar menuBar = new JMenuBar();
        JMenu exportMenu = new JMenu("Export");
        exportMenu.add(new AbstractAction("pcb dump"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PcbRenderer ar = new PcbRenderer();
                try {
                    StringBuilder builder = new StringBuilder();
                    ((AppendableRenderer)ar).render(builder, footprintEditor.getFootprint());
                    System.out.println(builder);
                }
                catch (IOException ioe) {
                    System.err.println(ioe);
                }
            }
        });
        exportMenu.addSeparator();
        exportMenu.add(new FileOutputAction("pcb", footprintEditor, new PcbRenderer(), "fp"));
        exportMenu.add(new FileOutputAction("kicad", footprintEditor, new KicadRenderer(), "emp"));
        menuBar.add(exportMenu);
        JMenu unitsMenu = new JMenu("Units");
        ButtonGroup unitsGroup = new ButtonGroup();
        for (final UnitType unitType : UnitType.values()) {
            JRadioButtonMenuItem unit = new JRadioButtonMenuItem(new AbstractAction(unitType.toString()){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    footprintEditor.setUnitType(unitType);
                }
            });
            unitsGroup.add(unit);
            unitsMenu.add(unit);
        }
        menuBar.add(unitsMenu);
        JMenu packagesMenu = new JMenu("Packages");
        ButtonGroup packagesGroup = new ButtonGroup();
        for (final PackageType packageType : PackageType.values()) {
            JRadioButtonMenuItem pack = new JRadioButtonMenuItem(new AbstractAction(packageType.toString()){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    footprintEditor.setPackageType(packageType);
                    frame.validate();
                }
            });
            packagesGroup.add(pack);
            packagesMenu.add(pack);
        }
        menuBar.add(packagesMenu);
        frame.setJMenuBar(menuBar);
        frame.setVisible(true);
    }

    private static final class FileOutputAction
    extends AbstractAction
    implements Runnable {
        private final FootprintEditor footprintEditor;
        private final AppendableRenderer renderer;
        private final FileNameExtensionFilter filter;
        private final String extension;

        public FileOutputAction(String name, FootprintEditor footprintEditor, AppendableRenderer renderer, String extension) {
            super(name);
            this.footprintEditor = footprintEditor;
            this.renderer = renderer;
            this.filter = new FileNameExtensionFilter(name, extension);
            this.extension = extension;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            Footprint footprint = this.footprintEditor.getFootprint();
            JFileChooser chooser = new JFileChooser(".");
            chooser.setFileFilter(this.filter);
            chooser.setSelectedFile(new File(footprint.getName() + "." + this.extension));
            try {
                while (chooser.showSaveDialog(null) == 0) {
                    File file = chooser.getSelectedFile();
                    if (file.exists() && JOptionPane.showConfirmDialog(null, "Overwrite file? " + file) != 0) continue;
                    FileWriter writer = new FileWriter(file);
                    this.renderer.render(writer, footprint);
                    ((Writer)writer).close();
                    break;
                }
            }
            catch (IOException ioe) {
                System.err.println(ioe);
            }
        }
    }
}

