/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import javax.swing.JComponent;
import org.cyclerecorder.footprintbuilder.FootprintEditor;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.renderer.Graphics2DRenderer;

public final class FootprintView
extends JComponent {
    private final FootprintEditor footprintEditor;

    public FootprintView(FootprintEditor footprintEditor) {
        this.footprintEditor = footprintEditor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g2);
        if (this.footprintEditor.isEditable()) {
            Footprint footprint = this.footprintEditor.getFootprint();
            try {
                Graphics2DRenderer g2Renderer = new Graphics2DRenderer();
                g2Renderer.render(g2, footprint);
            }
            catch (IOException ioe) {
                System.err.println(ioe);
            }
        }
    }
}

