/*
 * Decompiled with CFR 0.152.
 */
package org.cyclerecorder.footprintbuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.FootprintView;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.PackageType;
import org.cyclerecorder.footprintbuilder.data.UnitType;
import org.cyclerecorder.footprintbuilder.editable.OptionsEditable;
import org.cyclerecorder.footprintbuilder.editor.EditorPanel;
import org.cyclerecorder.footprintbuilder.editor.GridEditor;
import org.cyclerecorder.footprintbuilder.editor.OptionsEditor;
import org.cyclerecorder.footprintbuilder.editor.QuadEditor;
import org.cyclerecorder.footprintbuilder.editor.SilkEditor;

public final class FootprintEditor
extends JPanel
implements ChangeListener {
    private final OptionsEditable optionsEditable = new OptionsEditable();
    private final OptionsEditor optionsEditor = new OptionsEditor(this.optionsEditable, (ChangeListener)this);
    private EditorPanel editorPanel;
    private SilkEditor silkEditor;
    private UnitType unitType;
    private PackageType packageType;
    private FootprintView footprintView;

    public FootprintEditor() {
        super(new BorderLayout());
        this.add((Component)this.optionsEditor, "North");
    }

    public boolean isEditable() {
        return this.unitType != null && this.editorPanel != null;
    }

    public Footprint getFootprint() {
        Footprint footprint = new Footprint(this.unitType, this.optionsEditable);
        if (this.editorPanel != null) {
            this.editorPanel.fillFootprint(footprint);
            this.silkEditor.fillFootprint(footprint);
        }
        return footprint;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (this.isEditable() && this.footprintView != null) {
            this.footprintView.repaint();
        }
    }

    public void setUnitType(UnitType unitType) {
        this.unitType = unitType;
        this.optionsEditor.setUnitType(this.unitType);
        if (this.editorPanel != null) {
            this.editorPanel.setUnitType(this.unitType);
            this.silkEditor.setUnitType(this.unitType);
        }
        this.stateChanged(null);
    }

    public void setPackageType(PackageType packageType) {
        this.packageType = packageType;
        if (this.editorPanel != null) {
            this.remove(this.editorPanel);
            this.editorPanel = null;
        }
        if (this.silkEditor != null) {
            this.remove(this.silkEditor);
            this.silkEditor = null;
        }
        EditorPanel newEditorPanel = null;
        SilkEditor newSilkEditor = null;
        switch (this.packageType) {
            case QUAD: {
                newEditorPanel = new QuadEditor(this.packageType, this);
                newSilkEditor = new SilkEditor(this.packageType, this);
                break;
            }
            case GRID: 
            case GRID_PIN: {
                newEditorPanel = new GridEditor(this.packageType, this);
                newSilkEditor = new SilkEditor(this.packageType, this);
                break;
            }
            default: {
                return;
            }
        }
        this.editorPanel = newEditorPanel;
        this.silkEditor = newSilkEditor;
        this.add((Component)this.editorPanel, "Center");
        this.add((Component)this.silkEditor, "South");
        this.setUnitType(this.unitType);
    }

    public void setFootprintView(FootprintView footprintView) {
        this.footprintView = footprintView;
    }
}

