/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.editable.EditableEnum;

public final class EditableJComboBox extends JComboBox {
	private EditableJComboBox(final EditableComboBoxModel model, final ChangeListener changeListener) {
		super(model);
		this.addItemListener(new ItemListener() {
			public void itemStateChanged(final ItemEvent ie) {
				changeListener.stateChanged(new ChangeEvent(ie.getSource()));
			}
		});
	}
	public EditableJComboBox(final EditableEnum editable, final ChangeListener changeListener) {
		this(new EditableComboBoxModel(editable), changeListener);
	}

	private final static class EditableComboBoxModel extends AbstractListModel implements ComboBoxModel {
		private final EditableEnum editable;

		public EditableComboBoxModel(final EditableEnum editable) {
			this.editable = editable;
		}

		public int getSize() {
			return this.editable.getValues().length;
		}
		public Object getElementAt(final int row) {
			return this.editable.getValues()[row];
		}
		public Object getSelectedItem() {
			return this.editable.getValue();
		}
		public void setSelectedItem(final Object o) {
			this.editable.setEnumValue((Enum)o);
		}
	}
}

