/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.editor;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.gui.EditableJComboBox;
import org.cyclerecorder.footprintbuilder.gui.EditableJSpinner;
import org.cyclerecorder.footprintbuilder.editable.SilkEditable;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.PackageType;
import org.cyclerecorder.footprintbuilder.data.UnitType;

public class SilkEditor extends EditorPanel {
	private final SilkEditable silk = new SilkEditable();

	private final EditableJSpinner silkOffset;
	private final EditableJSpinner silkWidth;
	private final EditableJSpinner silkLength;
	private final EditableJComboBox silkMarker;

	public SilkEditor(final PackageType packageType, final ChangeListener changeListener) {
		super(packageType, changeListener);

		final GroupLayout layout = new GroupLayout(this);
//		layout.setAutoCreateGaps(true);
//		layout.setAutoCreateContainerGaps(true);
		this.setLayout(layout);

		final JLabel silkLabel = new JLabel("Silk");
		final JLabel silkOffsetLabel = new JLabel("Offset");
		this.silkOffset = new EditableJSpinner(true, this.silk.getSilkOffsetEditable(), changeListener);
		silkOffsetLabel.setLabelFor(silkOffset);
		final JLabel silkWidthLabel = new JLabel("Width");
		this.silkWidth = new EditableJSpinner(true, this.silk.getSilkWidthEditable(), changeListener);
		silkWidthLabel.setLabelFor(silkWidth);
		final JLabel silkLengthLabel = new JLabel("Length");
		this.silkLength = new EditableJSpinner(true, this.silk.getSilkLengthEditable(), changeListener);
		silkLengthLabel.setLabelFor(silkLength);
		final JLabel silkMarkerLabel = new JLabel("Marker");
		this.silkMarker = new EditableJComboBox(this.silk.getSilkMarkerEditable(), changeListener);
		silkMarkerLabel.setLabelFor(silkMarker);

		layout.linkSize(SwingConstants.HORIZONTAL, silkOffsetLabel, silkWidthLabel, silkLengthLabel, silkMarkerLabel);

		layout.setHorizontalGroup(layout.createParallelGroup()
			.addGroup(layout.createParallelGroup()
				.addComponent(silkLabel)
				.addGroup(layout.createSequentialGroup()
					.addGroup(layout.createParallelGroup()
						.addComponent(silkOffsetLabel)
						.addComponent(silkWidthLabel)
						.addComponent(silkLengthLabel)
						.addComponent(silkMarkerLabel)
					)
					.addGroup(layout.createParallelGroup()
						.addComponent(silkOffset)
						.addComponent(silkWidth)
						.addComponent(silkLength)
						.addComponent(silkMarker)
					)
				)
			)
		);
		layout.setVerticalGroup(layout.createSequentialGroup()
			.addGroup(layout.createSequentialGroup()
				.addComponent(silkLabel)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(silkOffsetLabel)
					.addComponent(silkOffset)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(silkWidthLabel)
					.addComponent(silkWidth)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(silkLengthLabel)
					.addComponent(silkLength)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(silkMarkerLabel)
					.addComponent(silkMarker)
				)
			)
		);
	}

	public void fillFootprint(final Footprint footprint) {
		this.silk.fillFootprint(footprint);
	}

	public void setUnitType(final UnitType unitType) {
		this.silkOffset.setUnitType(unitType);
		this.silkWidth.setUnitType(unitType);
		this.silkLength.setUnitType(unitType);
	}
}

