/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.editor;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.gui.EditableJComboBox;
import org.cyclerecorder.footprintbuilder.gui.EditableJSpinner;
import org.cyclerecorder.footprintbuilder.editable.PadEditable;
import org.cyclerecorder.footprintbuilder.editable.QuadEditable;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.PackageType;
import org.cyclerecorder.footprintbuilder.data.UnitType;

public class QuadEditor extends EditorPanel {
	private final QuadEditable quad = new QuadEditable();

	private final EditableJSpinner xPadWidth;
	private final EditableJSpinner xPadLength;
	private final EditableJSpinner quadXCount;
	private final EditableJSpinner quadXPitch;
	private final EditableJSpinner quadVerticalPitch;

	private final EditableJSpinner yPadWidth;
	private final EditableJSpinner yPadLength;
	private final EditableJSpinner quadYCount;
	private final EditableJSpinner quadYPitch;
	private final EditableJSpinner quadHorizontalPitch;

	private final EditableJComboBox quadOffsetType;

	private final EditableJSpinner ePadWidth;
	private final EditableJSpinner ePadLength;

	public QuadEditor(final PackageType packageType, final ChangeListener changeListener) {
		super(packageType, changeListener);

		final GroupLayout layout = new GroupLayout(this);
//		layout.setAutoCreateGaps(true);
//		layout.setAutoCreateContainerGaps(true);
		this.setLayout(layout);

		final PadEditable xpad = this.quad.getXPad();
		final PadEditable ypad = this.quad.getYPad();
		final PadEditable epad = this.quad.getEPad();

		final JLabel horizontalLabel = new JLabel("Top/Bottom Pads");
		final JLabel xPadWidthLabel = new JLabel("Pad Width");
		this.xPadWidth = new EditableJSpinner(true, xpad.getPadWidthEditable(), changeListener);
		xPadWidthLabel.setLabelFor(xPadWidth);
		final JLabel xPadLengthLabel = new JLabel("Pad Length");
		this.xPadLength = new EditableJSpinner(true, xpad.getPadLengthEditable(), changeListener);
		xPadLengthLabel.setLabelFor(xPadLength);
		final JLabel quadXCountLabel = new JLabel("Count");
		this.quadXCount = new EditableJSpinner(true, this.quad.getXCountEditable(), changeListener);
		quadXCountLabel.setLabelFor(quadXCount);
		final JLabel quadXPitchLabel = new JLabel("Pitch");
		this.quadXPitch = new EditableJSpinner(true, this.quad.getXPitchEditable(), changeListener);
		quadXPitchLabel.setLabelFor(quadXPitch);
		final JLabel quadVerticalPitchLabel = new JLabel("Vertical Pitch");
		this.quadVerticalPitch = new EditableJSpinner(true, this.quad.getVerticalPitchEditable(), changeListener);
		quadVerticalPitchLabel.setLabelFor(quadVerticalPitch);

		final JLabel verticalLabel = new JLabel("Left/Right Pads");
		final JLabel yPadWidthLabel = new JLabel("Pad Width");
		this.yPadWidth = new EditableJSpinner(true, ypad.getPadWidthEditable(), changeListener);
		yPadWidthLabel.setLabelFor(yPadWidth);
		final JLabel yPadLengthLabel = new JLabel("Pad Length");
		this.yPadLength = new EditableJSpinner(true, ypad.getPadLengthEditable(), changeListener);
		yPadLengthLabel.setLabelFor(yPadLength);
		final JLabel quadYCountLabel = new JLabel("Count");
		this.quadYCount = new EditableJSpinner(true, this.quad.getYCountEditable(), changeListener);
		quadYCountLabel.setLabelFor(quadYCount);
		final JLabel quadYPitchLabel = new JLabel("Pitch");
		this.quadYPitch = new EditableJSpinner(true, this.quad.getYPitchEditable(), changeListener);
		quadYPitchLabel.setLabelFor(quadYPitch);
		final JLabel quadHorizontalPitchLabel = new JLabel("Horizontal Pitch");
		this.quadHorizontalPitch = new EditableJSpinner(true, this.quad.getHorizontalPitchEditable(), changeListener);
		quadHorizontalPitchLabel.setLabelFor(quadHorizontalPitch);

		final JLabel quadOffsetTypeLabel = new JLabel("H/V Pitch Offset");
		this.quadOffsetType = new EditableJComboBox(this.quad.getOffsetTypeEditable(), changeListener);
		quadOffsetTypeLabel.setLabelFor(quadOffsetType);

		final JLabel ePadLabel = new JLabel("Exposed Pad");
		final JLabel ePadWidthLabel = new JLabel("Width");
		this.ePadWidth = new EditableJSpinner(true, epad.getPadWidthEditable(), changeListener);
		ePadWidthLabel.setLabelFor(ePadWidth);
		final JLabel ePadLengthLabel = new JLabel("Length");
		this.ePadLength = new EditableJSpinner(true, epad.getPadLengthEditable(), changeListener);
		ePadLengthLabel.setLabelFor(ePadLength);

		layout.linkSize(SwingConstants.HORIZONTAL, xPadWidthLabel, xPadLengthLabel, quadXCountLabel, quadXPitchLabel, quadVerticalPitchLabel);
		layout.linkSize(SwingConstants.HORIZONTAL, yPadWidthLabel, yPadLengthLabel, quadYCountLabel, quadYPitchLabel, quadHorizontalPitchLabel, quadOffsetTypeLabel);
		layout.linkSize(SwingConstants.HORIZONTAL, ePadWidthLabel, ePadLengthLabel);
		layout.linkSize(SwingConstants.HORIZONTAL, xPadWidthLabel, yPadWidthLabel, ePadWidthLabel);

		layout.setHorizontalGroup(layout.createParallelGroup()
			.addGroup(layout.createParallelGroup()
				.addComponent(horizontalLabel)
				.addGroup(layout.createSequentialGroup()
					.addGroup(layout.createParallelGroup()
						.addComponent(xPadWidthLabel)
						.addComponent(xPadLengthLabel)
						.addComponent(quadXCountLabel)
						.addComponent(quadXPitchLabel)
						.addComponent(quadVerticalPitchLabel)
					)
					.addGroup(layout.createParallelGroup()
						.addComponent(xPadWidth)
						.addComponent(xPadLength)
						.addComponent(quadXCount)
						.addComponent(quadXPitch)
						.addComponent(quadVerticalPitch)
					)
				)
			)
			.addGroup(layout.createParallelGroup()
				.addComponent(verticalLabel)
				.addGroup(layout.createSequentialGroup()
					.addGroup(layout.createParallelGroup()
						.addComponent(yPadWidthLabel)
						.addComponent(yPadLengthLabel)
						.addComponent(quadYCountLabel)
						.addComponent(quadYPitchLabel)
						.addComponent(quadHorizontalPitchLabel)
					)
					.addGroup(layout.createParallelGroup()
						.addComponent(yPadWidth)
						.addComponent(yPadLength)
						.addComponent(quadYCount)
						.addComponent(quadYPitch)
						.addComponent(quadHorizontalPitch)
					)
				)
			)
			.addGroup(layout.createParallelGroup()
				.addGroup(layout.createSequentialGroup()
					.addGroup(layout.createParallelGroup()
						.addComponent(quadOffsetTypeLabel)
					)
					.addGroup(layout.createParallelGroup()
						.addComponent(quadOffsetType)
					)
				)
			)
			.addGroup(layout.createParallelGroup()
				.addComponent(ePadLabel)
				.addGroup(layout.createSequentialGroup()
					.addGroup(layout.createParallelGroup()
						.addComponent(ePadWidthLabel)
						.addComponent(ePadLengthLabel)
					)
					.addGroup(layout.createParallelGroup()
						.addComponent(ePadWidth)
						.addComponent(ePadLength)
					)
				)
			)
		);
		layout.setVerticalGroup(layout.createSequentialGroup()
			.addGroup(layout.createSequentialGroup()
				.addComponent(horizontalLabel)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(xPadWidthLabel)
					.addComponent(xPadWidth)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(xPadLengthLabel)
					.addComponent(xPadLength)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(quadXCountLabel)
					.addComponent(quadXCount)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(quadXPitchLabel)
					.addComponent(quadXPitch)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(quadVerticalPitchLabel)
					.addComponent(quadVerticalPitch)
				)
			)
			.addGroup(layout.createSequentialGroup()
				.addComponent(verticalLabel)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(yPadWidthLabel)
					.addComponent(yPadWidth)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(yPadLengthLabel)
					.addComponent(yPadLength)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(quadYCountLabel)
					.addComponent(quadYCount)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(quadYPitchLabel)
					.addComponent(quadYPitch)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(quadHorizontalPitchLabel)
					.addComponent(quadHorizontalPitch)
				)
			)
			.addGroup(layout.createSequentialGroup()
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(quadOffsetTypeLabel)
					.addComponent(quadOffsetType)
				)
			)
			.addGroup(layout.createSequentialGroup()
				.addComponent(ePadLabel)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(ePadWidthLabel)
					.addComponent(ePadWidth)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(ePadLengthLabel)
					.addComponent(ePadLength)
				)
			)
		);
	}

	public void fillFootprint(final Footprint footprint) {
		this.quad.fillFootprint(footprint);
	}

	public void setUnitType(final UnitType unitType) {
		this.xPadWidth.setUnitType(unitType);
		this.xPadLength.setUnitType(unitType);
		this.quadXPitch.setUnitType(unitType);
		this.quadVerticalPitch.setUnitType(unitType);
		this.yPadWidth.setUnitType(unitType);
		this.yPadLength.setUnitType(unitType);
		this.quadYPitch.setUnitType(unitType);
		this.quadHorizontalPitch.setUnitType(unitType);
		this.ePadWidth.setUnitType(unitType);
		this.ePadLength.setUnitType(unitType);
	}
}

