/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.editor;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.editable.OptionsEditable;
import org.cyclerecorder.footprintbuilder.gui.EditableJSpinner;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.UnitType;

public class OptionsEditor extends EditorPanel {
	private final EditableJSpinner maskOffset;
	private final EditableJSpinner clearanceOffset;
	private final EditableJSpinner silkLineWidth;
	private final EditableJSpinner extraLength;

	public OptionsEditor(final OptionsEditable options, final ChangeListener changeListener) {
		super(null, changeListener);

		final GroupLayout layout = new GroupLayout(this);
//		layout.setAutoCreateGaps(true);
//		layout.setAutoCreateContainerGaps(true);
		this.setLayout(layout);

		final JLabel optionsLabel = new JLabel("Options");

		final JLabel maskOffsetLabel = new JLabel("Mask Offset");
		this.maskOffset = new EditableJSpinner(true, options.getMaskOffsetEditable(), changeListener);
		maskOffsetLabel.setLabelFor(this.maskOffset);

		final JLabel clearanceOffsetLabel = new JLabel("Clearance Offset");
		this.clearanceOffset = new EditableJSpinner(true, options.getClearanceOffsetEditable(), changeListener);
		clearanceOffsetLabel.setLabelFor(this.clearanceOffset);

		final JLabel silkLineWidthLabel = new JLabel("Silk Line Width");
		this.silkLineWidth = new EditableJSpinner(true, options.getSilkLineWidthEditable(), changeListener);
		silkLineWidthLabel.setLabelFor(this.silkLineWidth);

		final JLabel extraLengthLabel = new JLabel("Extra Length");
		this.extraLength = new EditableJSpinner(true, options.getExtraLengthEditable(), changeListener);
		extraLengthLabel.setLabelFor(this.extraLength);
		this.extraLength.setEnabled(false);

		layout.linkSize(SwingConstants.HORIZONTAL, maskOffsetLabel, clearanceOffsetLabel, silkLineWidthLabel, extraLengthLabel);

		layout.setHorizontalGroup(layout.createParallelGroup()
			.addGroup(layout.createParallelGroup()
				.addComponent(optionsLabel)
				.addGroup(layout.createSequentialGroup()
					.addGroup(layout.createParallelGroup()
						.addComponent(maskOffsetLabel)
						.addComponent(clearanceOffsetLabel)
						.addComponent(silkLineWidthLabel)
						.addComponent(extraLengthLabel)
					)
					.addGroup(layout.createParallelGroup()
						.addComponent(this.maskOffset)
						.addComponent(this.clearanceOffset)
						.addComponent(this.silkLineWidth)
						.addComponent(this.extraLength)
					)
				)
			)
		);
		layout.setVerticalGroup(layout.createSequentialGroup()
			.addGroup(layout.createSequentialGroup()
				.addComponent(optionsLabel)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(maskOffsetLabel)
					.addComponent(this.maskOffset)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(clearanceOffsetLabel)
					.addComponent(this.clearanceOffset)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(silkLineWidthLabel)
					.addComponent(this.silkLineWidth)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(extraLengthLabel)
					.addComponent(this.extraLength)
				)
			)
		);
	}

	public void fillFootprint(final Footprint footprint) {
	}

	public void setUnitType(final UnitType unitType) {
		this.maskOffset.setUnitType(unitType);
		this.clearanceOffset.setUnitType(unitType);
		this.silkLineWidth.setUnitType(unitType);
		this.extraLength.setUnitType(unitType);
	}
}

