/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.editor;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.data.PackageType;
import org.cyclerecorder.footprintbuilder.data.StyleType;
import org.cyclerecorder.footprintbuilder.data.UnitType;
import org.cyclerecorder.footprintbuilder.editable.GridEditable;
import org.cyclerecorder.footprintbuilder.gui.EditableJComboBox;
import org.cyclerecorder.footprintbuilder.gui.EditableJSpinner;

public class GridEditor extends EditorPanel {
	private final GridEditable grid = new GridEditable();

	private final EditableJSpinner padWidth;

	private final EditableJSpinner pinDiameter;
	private final EditableJSpinner holeDiameter;

	private final EditableJSpinner xCount;
	private final EditableJSpinner xPitch;
	private final EditableJSpinner yCount;
	private final EditableJSpinner yPitch;

	private final EditableJComboBox pinNumberType;

	public GridEditor(final PackageType packageType, final ChangeListener changeListener) {
		super(packageType, changeListener);

		final GroupLayout layout = new GroupLayout(this);
//		layout.setAutoCreateGaps(true);
//		layout.setAutoCreateContainerGaps(true);
		this.setLayout(layout);

		if (packageType == PackageType.GRID) {
			this.grid.getPad().setPadStyle(StyleType.CIRCLE);
		}

		final JLabel padLabel = new JLabel("Pad");
		final JLabel padWidthLabel = new JLabel("Width");
		this.padWidth = new EditableJSpinner(true, this.grid.getPad().getPadWidthEditable(), changeListener);
		padWidthLabel.setLabelFor(this.padWidth);

		final JLabel pinLabel = new JLabel("Pin");
		final JLabel pinDiameterLabel = new JLabel("Diameter");
		this.pinDiameter = new EditableJSpinner(true, this.grid.getPin().getPinDiameterEditable(), changeListener);
		pinDiameterLabel.setLabelFor(this.pinDiameter);
		final JLabel holeDiameterLabel = new JLabel("Hole Diameter");
		this.holeDiameter = new EditableJSpinner(true, this.grid.getPin().getHoleDiameterEditable(), changeListener);
		holeDiameterLabel.setLabelFor(this.holeDiameter);

		final JLabel xLabel = new JLabel("X");
		final JLabel xCountLabel = new JLabel("Count");
		this.xCount = new EditableJSpinner(true, this.grid.getXCountEditable(), changeListener);
		xCountLabel.setLabelFor(this.xCount);
		final JLabel xPitchLabel = new JLabel("Pitch");
		this.xPitch = new EditableJSpinner(true, this.grid.getXPitchEditable(), changeListener);
		xPitchLabel.setLabelFor(this.xPitch);

		final JLabel yLabel = new JLabel("Y");
		final JLabel yCountLabel = new JLabel("Count");
		this.yCount = new EditableJSpinner(true, this.grid.getYCountEditable(), changeListener);
		yCountLabel.setLabelFor(yCount);
		final JLabel yPitchLabel = new JLabel("Pitch");
		this.yPitch = new EditableJSpinner(true, this.grid.getYPitchEditable(), changeListener);
		yPitchLabel.setLabelFor(this.yPitch);

		final JLabel pinNumberTypeLabel = new JLabel("Pin Number Type");
		this.pinNumberType = new EditableJComboBox(this.grid.getPinNumberTypeEditable(), changeListener);
		pinNumberTypeLabel.setLabelFor(this.pinNumberType);

		if (packageType == PackageType.GRID) {
			pinDiameter.setEnabled(false);
			holeDiameter.setEnabled(false);
		} else if (packageType == PackageType.GRID_PIN) {
			padWidth.setEnabled(false);
		}

		layout.linkSize(SwingConstants.HORIZONTAL, padWidthLabel);
		layout.linkSize(SwingConstants.HORIZONTAL, pinDiameterLabel, holeDiameterLabel);
		layout.linkSize(SwingConstants.HORIZONTAL, xCountLabel, xPitchLabel);
		layout.linkSize(SwingConstants.HORIZONTAL, yCountLabel, yPitchLabel);
		layout.linkSize(SwingConstants.HORIZONTAL, pinNumberTypeLabel);
		layout.linkSize(SwingConstants.HORIZONTAL, padWidthLabel, pinDiameterLabel, xCountLabel, yCountLabel, pinNumberTypeLabel);

		layout.setHorizontalGroup(layout.createParallelGroup()
			.addGroup(layout.createParallelGroup()
				.addComponent(padLabel)
				.addGroup(layout.createSequentialGroup()
					.addGroup(layout.createParallelGroup()
						.addComponent(padWidthLabel)
					)
					.addGroup(layout.createParallelGroup()
						.addComponent(padWidth)
					)
				)
			)
			.addGroup(layout.createParallelGroup()
				.addComponent(pinLabel)
				.addGroup(layout.createSequentialGroup()
					.addGroup(layout.createParallelGroup()
						.addComponent(pinDiameterLabel)
						.addComponent(holeDiameterLabel)
					)
					.addGroup(layout.createParallelGroup()
						.addComponent(pinDiameter)
						.addComponent(holeDiameter)
					)
				)
			)
			.addGroup(layout.createParallelGroup()
				.addComponent(xLabel)
				.addGroup(layout.createSequentialGroup()
					.addGroup(layout.createParallelGroup()
						.addComponent(xCountLabel)
						.addComponent(xPitchLabel)
					)
					.addGroup(layout.createParallelGroup()
						.addComponent(xCount)
						.addComponent(xPitch)
					)
				)
			)
			.addGroup(layout.createParallelGroup()
				.addComponent(yLabel)
				.addGroup(layout.createSequentialGroup()
					.addGroup(layout.createParallelGroup()
						.addComponent(yCountLabel)
						.addComponent(yPitchLabel)
					)
					.addGroup(layout.createParallelGroup()
						.addComponent(yCount)
						.addComponent(yPitch)
					)
				)
			)
			.addGroup(layout.createParallelGroup()
				.addGroup(layout.createSequentialGroup()
					.addGroup(layout.createParallelGroup()
						.addComponent(pinNumberTypeLabel)
					)
					.addGroup(layout.createParallelGroup()
						.addComponent(this.pinNumberType)
					)
				)
			)

		);
		layout.setVerticalGroup(layout.createSequentialGroup()
			.addGroup(layout.createSequentialGroup()
				.addComponent(padLabel)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(padWidthLabel)
					.addComponent(padWidth)
				)
			)
			.addGroup(layout.createSequentialGroup()
				.addComponent(pinLabel)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(pinDiameterLabel)
					.addComponent(pinDiameter)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(holeDiameterLabel)
					.addComponent(holeDiameter)
				)
			)
			.addGroup(layout.createSequentialGroup()
				.addComponent(xLabel)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(xCountLabel)
					.addComponent(xCount)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(xPitchLabel)
					.addComponent(xPitch)
				)
			)
			.addGroup(layout.createSequentialGroup()
				.addComponent(yLabel)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(yCountLabel)
					.addComponent(yCount)
				)
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(yPitchLabel)
					.addComponent(yPitch)
				)
			)
			.addGroup(layout.createSequentialGroup()
				.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
					.addComponent(pinNumberTypeLabel)
					.addComponent(this.pinNumberType)
				)
			)
		);
	}

	public void fillFootprint(final Footprint footprint) {
		this.grid.fillFootprint(footprint);
	}

	public void setUnitType(final UnitType unitType) {
		this.padWidth.setUnitType(unitType);
		this.pinDiameter.setUnitType(unitType);
		this.holeDiameter.setUnitType(unitType);
		this.xPitch.setUnitType(unitType);
		this.yPitch.setUnitType(unitType);
	}
}

