/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.editable;

import org.cyclerecorder.footprintbuilder.data.StyleType;

public class PadEditable {
	public boolean isValid() {
		return ((this.getPadWidth() > 0.0D) || (this.getPadLength() > 0.0D));
	}

	private StyleType padStyle = StyleType.RECTANGLE;
	public StyleType getPadStyle() {
		return this.padStyle;
	}
	public void setPadStyle(final StyleType padStyle) {
		this.padStyle = padStyle;
	}

	private final EditableDouble padWidth = new EditableDouble();
	public double getPadWidth() {
		return this.padWidth.doubleValue();
	}
	public EditableDouble getPadWidthEditable() {
		return this.padWidth;
	}

	private final EditableDouble padLength = new EditableDouble();
	public double getPadLength() {
		return this.padLength.doubleValue();
	}
	public EditableDouble getPadLengthEditable() {
		return this.padLength;
	}
}

