/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.editable;

import org.cyclerecorder.footprintbuilder.editable.EditableDouble;

public final class OptionsEditable {
	private final EditableDouble maskOffset = new EditableDouble();
	public EditableDouble getMaskOffsetEditable() {
		return this.maskOffset;
	}
	public double getMaskOffset() {
		return this.maskOffset.doubleValue();
	}

	private final EditableDouble clearanceOffset = new EditableDouble();
	public EditableDouble getClearanceOffsetEditable() {
		return this.clearanceOffset;
	}
	public double getClearanceOffset() {
		return this.clearanceOffset.doubleValue();
	}

	private final EditableDouble silkLineWidth = new EditableDouble();
	public EditableDouble getSilkLineWidthEditable() {
		return this.silkLineWidth;
	}
	public double getSilkLineWidth() {
		return this.silkLineWidth.doubleValue();
	}

	private final EditableDouble extraLength = new EditableDouble();
	public EditableDouble getExtraLengthEditable() {
		return this.extraLength;
	}
	public double getExtraLength() {
		return this.extraLength.doubleValue();
	}
}

