/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.editable;

public class EditableInteger extends EditableNumber {
	private int value;

	public EditableInteger() {
	}
	public EditableInteger(final Number value) {
		this.setValue(value);
	}
	public EditableInteger(final int value) {
		this.value = value;
	}

	public void setValue(final Number value) {
		this.value = value.intValue();
	}
	public void setValue(final int value) {
		this.value = value;
	}
	public double doubleValue() {
		return (double)this.value;
	}
	public float floatValue() {
		return (float)this.value;
	}
	public long longValue() {
		return (long)this.value;
	}
	public int intValue() {
		return this.value;
	}
}

