/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.editable;

public class EditableEnum<E extends Enum> {
	private final E[] values;
	private E value;

	public EditableEnum(final E[] values) {
		this(values, null);
	}
	public EditableEnum(final E[] values, final E value) {
		this.values = values;
		this.setValue(value);
	}

	public void setValue(final E value) {
		this.value = value;
	}
	public E getValue() {
		return this.value;
	}

	public void setEnumValue(final Object o) {
		for (E e : this.values) {
			if (e == o) {
				this.setValue(e);
			}
		}
	}

	public E[] getValues() {
		return this.values;
	}
}

