/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.data;

public enum UnitType {
	MM("mm", 39.37007874D), // Based on MM_TO_MIL value from pcb (src/const.h)
	MIL("mil", 1.0D),
	INCH("inch", 1000.0D),
	;

	private UnitType(final String description, final double mils) {
		this.description = description;
		this.mils = mils;
	}

	private final String description;
	public String toString() {
		return this.description;
	}

	private final double mils;
	public double toMil(final double value) {
		return (value * mils);
	}
	public double toDeciMil(final double value) {
		return (value * (mils * 10.0D));
	}
	public double toCentiMil(final double value) {
		return (value * (mils * 100.0D));
	}

	public static double convert(final UnitType from, final double value, final UnitType to) {
		if (from == null) {
			return 0.0D;
		} else if (from == to) {
			return value;
		}
		return ((value * from.mils) / to.mils);
	}
}

