/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.data;

import org.cyclerecorder.footprintbuilder.Utility;

public final class Quadrilateral {
	private double x1; 
	private double y1; 
	private double x2; 
	private double y2; 
	private double x3; 
	private double y3; 
	private double x4; 
	private double y4; 

	public Quadrilateral() {
	}
	public Quadrilateral(final double x1, final double y1, final double x2, final double y2, final double x3, final double y3, final double x4, final double y4) {
		this.setP1(x1, y1);
		this.setP2(x2, y2);
		this.setP3(x3, y3);
		this.setP4(x4, y4);
	}
	public Quadrilateral(final Point p1, final Point p2, final Point p3, final Point p4) {
		this.setP1(p1.getX(), p1.getY());
		this.setP2(p2.getX(), p2.getY());
		this.setP3(p3.getX(), p3.getY());
		this.setP4(p4.getX(), p4.getY());
	}

	public void setP1(final double x, final double y) {
		this.x1 = x;
		this.y1 = y;
	}
	public void setP2(final double x, final double y) {
		this.x2 = x;
		this.y2 = y;
	}
	public void setP3(final double x, final double y) {
		this.x3 = x;
		this.y3 = y;
	}
	public void setP4(final double x, final double y) {
		this.x4 = x;
		this.y4 = y;
	}

	public double getX1() {
		return this.x1;
	}
	public double getY1() {
		return this.y1;
	}
	public double getX2() {
		return this.x2;
	}
	public double getY2() {
		return this.y2;
	}
	public double getX3() {
		return this.x3;
	}
	public double getY3() {
		return this.y3;
	}
	public double getX4() {
		return this.x4;
	}
	public double getY4() {
		return this.y4;
	}

	public void rotate(final double angle) {
		final double cos = Utility.getCosOfDegrees(angle);
		final double sin = Utility.getSinOfDegrees(angle);
		double _x;
		double _y;

		_x = this.x1;
		_y = this.y1;
		this.x1 = ((cos * _x) + (-sin * _y));
		this.y1 = ((sin * _x) + (cos * _y));
		_x = this.x2;
		_y = this.y2;
		this.x2 = ((cos * _x) + (-sin * _y));
		this.y2 = ((sin * _x) + (cos * _y));
		_x = this.x3;
		_y = this.y3;
		this.x3 = ((cos * _x) + (-sin * _y));
		this.y3 = ((sin * _x) + (cos * _y));
		_x = this.x4;
		_y = this.y4;
		this.x4 = ((cos * _x) + (-sin * _y));
		this.y4 = ((sin * _x) + (cos * _y));
	}
	public void translate(final double tx, final double ty) {
		this.x1 += tx;
		this.y1 += ty;
		this.x2 += tx;
		this.y2 += ty;
		this.x3 += tx;
		this.y3 += ty;
		this.x4 += tx;
		this.y4 += ty;
	}

	public void addBounds(final BoundingRectangle br) {
		final double xmin = Math.min(Math.min(this.x1, this.x2), Math.min(this.x3, this.x4));
		final double xmax = Math.max(Math.max(this.x1, this.x2), Math.max(this.x3, this.x4));
		final double ymin = Math.min(Math.min(this.y1, this.y2), Math.min(this.y3, this.y4));
		final double ymax = Math.max(Math.max(this.y1, this.y2), Math.max(this.y3, this.y4));
		br.add(xmin, xmax, ymin, ymax);
	}

	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("[").append(this.x1);
		builder.append(",").append(this.y1);
		builder.append(",").append(this.x2);
		builder.append(",").append(this.y2);
		builder.append(",").append(this.x3);
		builder.append(",").append(this.y3);
		builder.append(",").append(this.x4);
		builder.append(",").append(this.y4);
		builder.append("]");
		return builder.toString();
	}
}

