/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.data;

public final class Point implements Comparable<Point> {
	private double x; 
	private double y; 

	public Point() {
	}
	public Point(final double x, final double y) {
		this.x = x;
		this.y = y;
	}
	public Point(final Point point) {
		this(point.x, point.y);
	}

	public double getX() {
		return this.x;
	}
	public double getY() {
		return this.y;
	}

	public boolean equals(final Object o) {
		if (o instanceof Point) {
			final Point point = (Point)o;
			return ((this.x == point.x) && (this.y == point.y));
		}
		return false;
	}
	public int compareTo(final Point point) {
		if (this.x == point.x) {
			if (this.y == point.y) {
				return 0;
			} else if (this.y < point.y) {
				return -1;
			}
		} else if (this.x < point.x) {
			return -1;
		}
		return 1;
	}
	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("[").append(this.x);
		builder.append(",").append(this.y);
		builder.append("]");
		return builder.toString();
	}
}

