/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.data;

public enum PinNumberType {
	NUMERIC {
		public String getPinNumber(final int number, final int ix, final int iy) {
			return Integer.toString(number);
		}
	},
	ALPHANUMERIC {
		public String getPinNumber(final int number, final int ix, final int iy) {
			final StringBuilder sb = new StringBuilder();
			int x = ix / ALPHANUMBERS.length;
			if (x > 0) {
				sb.append(ALPHANUMBERS[(x - 1) % ALPHANUMBERS.length]);
			}
			sb.append(ALPHANUMBERS[ix % ALPHANUMBERS.length]);
			return sb.append(iy + 1).toString();
		}
	},
	;
	public abstract String getPinNumber(final int number, final int ix, final int iy);

	private static final char[] ALPHANUMBERS = {
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K',
		'L', 'M', 'N', 'P', 'R', 'T', 'U', 'V', 'W', 'Y'
	};

}

