/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.data;

public final class PadPin {
	public PadPin() {
	}
	public PadPin(final double x, final double y, final String number) {
		this.setX(x);
		this.setY(y);
		this.setNumber(number);
	}

	private double x;
	public double getX() {
		return this.x;
	}
	public void setX(final double x) {
		this.x = x;
	}

	private double y;
	public double getY() {
		return this.y;
	}
	public void setY(final double y) {
		this.y = y;
	}

	private String number;
	public String getNumber() {
		return this.number;
	}
	public void setNumber(final String number) {
		this.number = number;
	}

	private double xOffset;
	public double getXOffset() {
		return this.xOffset;
	}
	public void setXOffset(final double xOffset) {
		this.xOffset = xOffset;
	}

	private double yOffset;
	public double getYOffset() {
		return this.yOffset;
	}
	public void setYOffset(final double yOffset) {
		this.yOffset = yOffset;
	}

	private double angle;
	public double getAngle() {
		return this.angle;
	}
	public void setAngle(final double angle) {
		this.angle = angle;
	}


	private boolean pad;
	public boolean isPad() {
		return this.pad;
	}
	public void setPad(final boolean pad) {
		this.pad = pad;
	}

	private double width;
	public double getPadWidth() {
		return this.width;
	}
	public void setPadWidth(final double width) {
		this.width = width;
	}

	private double length;
	public double getPadLength() {
		return this.length;
	}
	public void setPadLength(final double length) {
		this.length = length;
	}


	private boolean pin;
	public boolean isPin() {
		return this.pin;
	}
	public void setPin(final boolean pin) {
		this.pin = pin;
	}

	private double pinDiameter;
	public double getPinDiameter() {
		return this.pinDiameter;
	}
	public void setPinDiameter(final double pinDiameter) {
		this.pinDiameter = pinDiameter;
	}

	private double holeDiameter;
	public double getHoleDiameter() {
		return this.holeDiameter;
	}
	public void setHoleDiameter(final double holeDiameter) {
		this.holeDiameter = holeDiameter;
	}

	private boolean holeOnly;
	public boolean isHoleOnly() {
		return this.holeOnly;
	}
	public void setHoleOnly(final boolean holeOnly) {
		this.holeOnly = holeOnly;
	}


	private boolean rectangle;
	public boolean isRectangle() {
		return this.rectangle;
	}
	public void setRectangle(final boolean rectangle) {
		this.rectangle = rectangle;
	}

	private boolean pinOne;
	public boolean isPinOne() {
		return this.pinOne;
	}
	public void setPinOne(final boolean pinOne) {
		this.pinOne = pinOne;
	}


	private double maskOffset;
	public double getMaskOffset() {
		return this.maskOffset;
	}
	public void setMaskOffset(final double maskOffset) {
		this.maskOffset = maskOffset;
	}

	private double clearanceOffset;
	public double getClearanceOffset() {
		return this.clearanceOffset;
	}
	public void setClearanceOffset(final double clearanceOffset) {
		this.clearanceOffset = clearanceOffset;
	}
}

