/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.data;

public final class Line {
	private double x1; 
	private double y1; 
	private double x2; 
	private double y2; 

	public Line() {
	}
	public Line(final double x1, final double y1, final double x2, final double y2) {
		this.x1 = x1;
		this.y1 = y1;
		this.x2 = x2;
		this.y2 = y2;
	}
	public Line(final Line line) {
		this(line.x1, line.y1, line.x2, line.y2);
	}
	public Line(final Point p1, final Point p2) {
		this(p1.getX(), p1.getY(), p2.getX(), p2.getY());
	}

	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("[").append(this.x1);
		builder.append(",").append(this.y1);
		builder.append(",").append(this.x2);
		builder.append(",").append(this.y2);
		builder.append("]");
		return builder.toString();
	}

	public boolean isVertical() {
		return (this.x1 == this.x2);
	}
	public boolean hasVerticalLength() {
		return (this.y1 != this.y2);
	}
	public boolean isHorizontal() {
		return (this.y1 == this.y2);
	}
	public boolean hasHorizontalLength() {
		return (this.x1 != this.x2);
	}

	public double getX1() {
		return this.x1;
	}
	public double getY1() {
		return this.y1;
	}
	public double getX2() {
		return this.x2;
	}
	public double getY2() {
		return this.y2;
	}
}

