/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder.data;

public final class BoundingRectangle {
	private double left;
	private double right;
	private double top;
	private double bottom;

	public BoundingRectangle() {
		this(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
	}
	public BoundingRectangle(final double left, final double right, final double top, final double bottom) {
		this.left = left;
		this.right = right;
		this.top = top;
		this.bottom = bottom;
	}

	public void add(final double left, final double right, final double top, final double bottom) {
		this.left = min(this.left, left);
		this.right = max(this.right, right);
		this.top = min(this.top, top);
		this.bottom = max(this.bottom, bottom);
	}

	private static double min(final double a, final double b) {
		if (Double.isNaN(a)) {
			return b;
		} else {
			return Math.min(a, b);
		}
	}
	private static double max(final double a, final double b) {
		if (Double.isNaN(a)) {
			return b;
		} else {
			return Math.max(a, b);
		}
	}

	public double getLeft() {
		return this.left;
	}
	public double getRight() {
		return this.right;
	}
	public double getTop() {
		return this.top;
	}
	public double getBottom() {
		return this.bottom;
	}

	public double getWidth() {
		return (this.right - this.left);
	}
	public double getLength() {
		return (this.bottom - this.top);
	}

	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("[").append(this.left);
		builder.append(",").append(this.right);
		builder.append(",").append(this.top);
		builder.append(",").append(this.bottom);
		builder.append("]");
		return builder.toString();
	}
}

