/*
 * Copyright (C) 2008 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder;

public final class Utility {
	public static double getSinOfDegrees(final double angle) {
		if ((angle % 90.0D) == 0.0D) {
			switch ((int)(angle / 90.0D) & 3) {
			case 0: return 0.0D;
			case 1: return 1.0D;
			case 2: return 0.0D;
			case 3: return -1.0D;
			}
		}
		return Math.sin(Math.toRadians(angle));
	}
	public static double getCosOfDegrees(final double angle) {
		if ((angle % 90.0D) == 0.0D) {
			switch ((int)(angle / 90.0D) & 3) {
			case 0: return 1.0D;
			case 1: return 0.0D;
			case 2: return -1.0D;
			case 3: return 0.0D;
			}
		}
		return Math.cos(Math.toRadians(angle));
	}
}

