/*
 * Copyright (C) 2008, 2009 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import javax.swing.JComponent;
import org.cyclerecorder.footprintbuilder.data.Footprint;
import org.cyclerecorder.footprintbuilder.renderer.Graphics2DRenderer;

public final class FootprintView extends JComponent {
	private final FootprintEditor footprintEditor;

	public FootprintView(final FootprintEditor footprintEditor) {
		this.footprintEditor = footprintEditor;
	}

	protected void paintComponent(final Graphics g) {
		final Graphics2D g2 = (Graphics2D)g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		super.paintComponent(g2);

		if (this.footprintEditor.isEditable()) {
			final Footprint footprint = this.footprintEditor.getFootprint();

			try {
				final Graphics2DRenderer g2Renderer = new Graphics2DRenderer();
				g2Renderer.render(g2, footprint);
			} catch (final IOException ioe) {
				System.err.println(ioe);
			}
		}
	}
}

