/*
 * Copyright (C) 2008, 2009 Robert Fitzsimons
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  Look for the COPYING file in the top
 * level directory.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.cyclerecorder.footprintbuilder;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cyclerecorder.footprintbuilder.data.*;
import org.cyclerecorder.footprintbuilder.editor.*;
import org.cyclerecorder.footprintbuilder.editable.*;
import org.cyclerecorder.footprintbuilder.renderer.*;

public final class FootprintEditor extends JPanel implements ChangeListener {
	private final OptionsEditable optionsEditable = new OptionsEditable();

	private final OptionsEditor optionsEditor = new OptionsEditor(this.optionsEditable, this);
	private EditorPanel editorPanel;
	private SilkEditor silkEditor;

	public FootprintEditor() {
		super(new BorderLayout());

		this.add(this.optionsEditor, BorderLayout.NORTH);
	}

	public boolean isEditable() {
		return ((this.unitType != null) && (this.editorPanel != null));
	}
	public Footprint getFootprint() {
		final Footprint footprint = new Footprint(this.unitType, this.optionsEditable);

		if (this.editorPanel != null) {
			this.editorPanel.fillFootprint(footprint);
			this.silkEditor.fillFootprint(footprint);
		}

		return footprint;
	}

	public void stateChanged(final ChangeEvent ce) {
		if ((this.isEditable()) && (this.footprintView != null)) {
			this.footprintView.repaint();
		}
	}

	private UnitType unitType;
	public void setUnitType(final UnitType unitType) {
		this.unitType = unitType;

		this.optionsEditor.setUnitType(this.unitType);
		if (this.editorPanel != null) {
			this.editorPanel.setUnitType(this.unitType);
			this.silkEditor.setUnitType(this.unitType);
		}

		this.stateChanged(null);
	}

	private PackageType packageType;
	public void setPackageType(final PackageType packageType) {
		this.packageType = packageType;

		if (this.editorPanel != null) {
			this.remove(this.editorPanel);
			this.editorPanel = null;
		}
		if (this.silkEditor != null) {
			this.remove(this.silkEditor);
			this.silkEditor = null;
		}

		EditorPanel newEditorPanel = null;
		SilkEditor newSilkEditor = null;
		switch (this.packageType) {
		case QUAD:
			newEditorPanel = new QuadEditor(this.packageType, this);
			newSilkEditor = new SilkEditor(this.packageType, this);
			break;
		case GRID:
		case GRID_PIN:
			newEditorPanel = new GridEditor(this.packageType, this);
			newSilkEditor = new SilkEditor(this.packageType, this);
			break;
//		case TOP_BOTTOM:
//			newEditorPanel = new RectangleEditor(this.packageType, this);
//			newSilkEditor = new SilkEditor(this.packageType, this);
//			break;
		default:
			return;
		}
		this.editorPanel = newEditorPanel;
		this.silkEditor = newSilkEditor;

		this.add(this.editorPanel, BorderLayout.CENTER);
		this.add(this.silkEditor, BorderLayout.SOUTH);

		this.setUnitType(this.unitType);
	}

	private FootprintView footprintView;
	public void setFootprintView(final FootprintView footprintView) {
		this.footprintView = footprintView;
	}
}

